/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.osee.framework.logging.BaseStatus;
import org.eclipse.osee.framework.logging.IHealthStatus;
import org.eclipse.osee.framework.logging.ILoggerListener;

public class SevereLoggingMonitor
implements ILoggerListener {
    private boolean ignore;
    private final List<IHealthStatus> status = new CopyOnWriteArrayList<IHealthStatus>();

    @Override
    public void log(String loggerName, Level level, String message, Throwable th) {
        if (!this.ignore) {
            this.status.add(new BaseStatus(loggerName, level, message, th));
        }
    }

    public List<IHealthStatus> getAllLogs() {
        return this.status;
    }

    public void pause() {
        this.ignore = true;
    }

    public void resume() {
        this.ignore = false;
    }

    public List<IHealthStatus> getSevereLogs() {
        ArrayList<IHealthStatus> severeStatus = new ArrayList<IHealthStatus>(this.status.size());
        for (IHealthStatus healthStatus : this.status) {
            if (healthStatus.getLevel() != Level.SEVERE) continue;
            severeStatus.add(healthStatus);
        }
        return severeStatus;
    }

    public List<IHealthStatus> getLogsAtLevel(Level level) {
        ArrayList<IHealthStatus> warningStatus = new ArrayList<IHealthStatus>(this.status.size());
        for (IHealthStatus healthStatus : this.status) {
            if (healthStatus.getLevel() != level) continue;
            warningStatus.add(healthStatus);
        }
        return warningStatus;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSevereLogs().size());
        sb.append(" Severe logs captured.\n");
        for (IHealthStatus health : this.getSevereLogs()) {
            sb.append(health.getException() != null ? health.getException().getMessage() : health.getMessage());
            sb.append("\n");
        }
        return sb.toString();
    }
}

