/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Dates;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.DateUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractDateAssert<SELF extends AbstractDateAssert<SELF>>
extends AbstractAssert<SELF, Date> {
    private static final List<DateFormat> DEFAULT_DATE_FORMATS = Lists.list(DateUtil.newIsoDateTimeWithMsAndIsoTimeZoneFormat(), DateUtil.newIsoDateTimeWithMsFormat(), DateUtil.newTimestampDateFormat(), DateUtil.newIsoDateTimeWithIsoTimeZoneFormat(), DateUtil.newIsoDateTimeFormat(), DateUtil.newIsoDateFormat());
    private static final String DATE_FORMAT_PATTERN_SHOULD_NOT_BE_NULL = "Given date format pattern should not be null";
    private static final String DATE_FORMAT_SHOULD_NOT_BE_NULL = "Given date format should not be null";
    @VisibleForTesting
    static ThreadLocal<LinkedHashSet<DateFormat>> userDateFormats = new ThreadLocal<LinkedHashSet<DateFormat>>(){

        @Override
        protected LinkedHashSet<DateFormat> initialValue() {
            return new LinkedHashSet<DateFormat>();
        }
    };
    @VisibleForTesting
    Dates dates = Dates.instance();

    public AbstractDateAssert(Date actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isEqualTo(String dateAsString) {
        return (SELF)((AbstractDateAssert)this.isEqualTo(this.parse(dateAsString)));
    }

    public SELF isEqualToIgnoringHours(String dateAsString) {
        return this.isEqualToIgnoringHours(this.parse(dateAsString));
    }

    public SELF isEqualToIgnoringHours(Date date) {
        this.dates.assertIsEqualWithPrecision(this.info, (Date)this.actual, date, TimeUnit.HOURS);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isEqualToIgnoringMinutes(String dateAsString) {
        return this.isEqualToIgnoringMinutes(this.parse(dateAsString));
    }

    public SELF isEqualToIgnoringMinutes(Date date) {
        this.dates.assertIsEqualWithPrecision(this.info, (Date)this.actual, date, TimeUnit.MINUTES);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isEqualToIgnoringSeconds(String dateAsString) {
        return this.isEqualToIgnoringSeconds(this.parse(dateAsString));
    }

    public SELF isEqualToIgnoringSeconds(Date date) {
        this.dates.assertIsEqualWithPrecision(this.info, (Date)this.actual, date, TimeUnit.SECONDS);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isEqualToIgnoringMillis(String dateAsString) {
        return this.isEqualToIgnoringMillis(this.parse(dateAsString));
    }

    public SELF isEqualToIgnoringMillis(Date date) {
        this.dates.assertIsEqualWithPrecision(this.info, (Date)this.actual, date, TimeUnit.MILLISECONDS);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isNotEqualTo(String dateAsString) {
        return (SELF)((AbstractDateAssert)this.isNotEqualTo(this.parse(dateAsString)));
    }

    public SELF isIn(String ... datesAsString) {
        Date[] dates = new Date[datesAsString.length];
        for (int i = 0; i < datesAsString.length; ++i) {
            dates[i] = this.parse(datesAsString[i]);
        }
        return (SELF)((AbstractDateAssert)this.isIn(dates));
    }

    public SELF isInWithStringDateCollection(Collection<String> datesAsString) {
        return (SELF)((AbstractDateAssert)this.isIn((Iterable)datesAsString.stream().map(this::parse).collect(Collectors.toList())));
    }

    public SELF isNotIn(String ... datesAsString) {
        Date[] dates = new Date[datesAsString.length];
        for (int i = 0; i < datesAsString.length; ++i) {
            dates[i] = this.parse(datesAsString[i]);
        }
        return (SELF)((AbstractDateAssert)this.isNotIn(dates));
    }

    public SELF isNotInWithStringDateCollection(Collection<String> datesAsString) {
        return (SELF)((AbstractDateAssert)this.isNotIn((Iterable)datesAsString.stream().map(this::parse).collect(Collectors.toList())));
    }

    public SELF isBefore(Date other) {
        this.dates.assertIsBefore(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isBefore(String dateAsString) {
        return this.isBefore(this.parse(dateAsString));
    }

    @Deprecated
    public SELF isBeforeOrEqualsTo(Date other) {
        this.dates.assertIsBeforeOrEqualTo(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(Date other) {
        this.dates.assertIsBeforeOrEqualTo(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @Deprecated
    public SELF isBeforeOrEqualsTo(String dateAsString) {
        return this.isBeforeOrEqualTo(this.parse(dateAsString));
    }

    public SELF isBeforeOrEqualTo(String dateAsString) {
        return this.isBeforeOrEqualTo(this.parse(dateAsString));
    }

    public SELF isAfter(Date other) {
        this.dates.assertIsAfter(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isAfter(String dateAsString) {
        return this.isAfter(this.parse(dateAsString));
    }

    @Deprecated
    public SELF isAfterOrEqualsTo(Date other) {
        this.dates.assertIsAfterOrEqualTo(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(Date other) {
        this.dates.assertIsAfterOrEqualTo(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @Deprecated
    public SELF isAfterOrEqualsTo(String dateAsString) {
        return this.isAfterOrEqualTo(this.parse(dateAsString));
    }

    public SELF isAfterOrEqualTo(String dateAsString) {
        return this.isAfterOrEqualTo(this.parse(dateAsString));
    }

    public SELF isBetween(Date start, Date end) {
        return this.isBetween(start, end, true, false);
    }

    public SELF isBetween(String start, String end) {
        return this.isBetween(this.parse(start), this.parse(end));
    }

    public SELF isBetween(Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsBetween(this.info, (Date)this.actual, start, end, inclusiveStart, inclusiveEnd);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isBetween(String start, String end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsBetween(this.info, (Date)this.actual, this.parse(start), this.parse(end), inclusiveStart, inclusiveEnd);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isNotBetween(Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsNotBetween(this.info, (Date)this.actual, start, end, inclusiveStart, inclusiveEnd);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isNotBetween(String start, String end, boolean inclusiveStart, boolean inclusiveEnd) {
        return this.isNotBetween(this.parse(start), this.parse(end), inclusiveStart, inclusiveEnd);
    }

    public SELF isNotBetween(Date start, Date end) {
        return this.isNotBetween(start, end, true, false);
    }

    public SELF isNotBetween(String start, String end) {
        return this.isNotBetween(this.parse(start), this.parse(end), true, false);
    }

    public SELF isInThePast() {
        this.dates.assertIsInThePast(this.info, (Date)this.actual);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isToday() {
        this.dates.assertIsToday(this.info, (Date)this.actual);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInTheFuture() {
        this.dates.assertIsInTheFuture(this.info, (Date)this.actual);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isBeforeYear(int year) {
        this.dates.assertIsBeforeYear(this.info, (Date)this.actual, year);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isAfterYear(int year) {
        this.dates.assertIsAfterYear(this.info, (Date)this.actual, year);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF hasYear(int year) {
        this.dates.assertHasYear(this.info, (Date)this.actual, year);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @Deprecated
    public SELF isWithinYear(int year) {
        this.dates.assertHasYear(this.info, (Date)this.actual, year);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF hasMonth(int month) {
        this.dates.assertHasMonth(this.info, (Date)this.actual, month);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @Deprecated
    public SELF isWithinMonth(int month) {
        this.dates.assertHasMonth(this.info, (Date)this.actual, month);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF hasDayOfMonth(int dayOfMonth) {
        this.dates.assertHasDayOfMonth(this.info, (Date)this.actual, dayOfMonth);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @Deprecated
    public SELF isWithinDayOfMonth(int dayOfMonth) {
        this.dates.assertHasDayOfMonth(this.info, (Date)this.actual, dayOfMonth);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF hasDayOfWeek(int dayOfWeek) {
        this.dates.assertHasDayOfWeek(this.info, (Date)this.actual, dayOfWeek);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @Deprecated
    public SELF isWithinDayOfWeek(int dayOfWeek) {
        this.dates.assertHasDayOfWeek(this.info, (Date)this.actual, dayOfWeek);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF hasHourOfDay(int hourOfDay) {
        this.dates.assertHasHourOfDay(this.info, (Date)this.actual, hourOfDay);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @Deprecated
    public SELF isWithinHourOfDay(int hourOfDay) {
        this.dates.assertHasHourOfDay(this.info, (Date)this.actual, hourOfDay);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF hasMinute(int minute) {
        this.dates.assertHasMinute(this.info, (Date)this.actual, minute);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @Deprecated
    public SELF isWithinMinute(int minute) {
        this.dates.assertHasMinute(this.info, (Date)this.actual, minute);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF hasSecond(int second) {
        this.dates.assertHasSecond(this.info, (Date)this.actual, second);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @Deprecated
    public SELF isWithinSecond(int second) {
        this.dates.assertHasSecond(this.info, (Date)this.actual, second);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF hasMillisecond(int millisecond) {
        this.dates.assertHasMillisecond(this.info, (Date)this.actual, millisecond);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @Deprecated
    public SELF isWithinMillisecond(int millisecond) {
        this.dates.assertHasMillisecond(this.info, (Date)this.actual, millisecond);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInSameYearAs(Date other) {
        this.dates.assertIsInSameYearAs(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInSameYearAs(String dateAsString) {
        return this.isInSameYearAs(this.parse(dateAsString));
    }

    public SELF isInSameMonthAs(Date other) {
        this.dates.assertIsInSameMonthAs(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInSameMonthAs(String dateAsString) {
        return this.isInSameMonthAs(this.parse(dateAsString));
    }

    public SELF isInSameDayAs(Date other) {
        this.dates.assertIsInSameDayAs(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInSameDayAs(String dateAsString) {
        return this.isInSameDayAs(this.parse(dateAsString));
    }

    public SELF isInSameHourWindowAs(Date other) {
        this.dates.assertIsInSameHourWindowAs(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInSameHourWindowAs(String dateAsString) {
        return this.isInSameHourWindowAs(this.parse(dateAsString));
    }

    public SELF isInSameHourAs(Date other) {
        this.dates.assertIsInSameHourAs(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInSameHourAs(String dateAsString) {
        return this.isInSameHourAs(this.parse(dateAsString));
    }

    public SELF isInSameMinuteWindowAs(Date other) {
        this.dates.assertIsInSameMinuteWindowAs(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInSameMinuteWindowAs(String dateAsString) {
        return this.isInSameMinuteWindowAs(this.parse(dateAsString));
    }

    public SELF isInSameMinuteAs(Date other) {
        this.dates.assertIsInSameMinuteAs(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInSameMinuteAs(String dateAsString) {
        return this.isInSameMinuteAs(this.parse(dateAsString));
    }

    public SELF isInSameSecondWindowAs(Date other) {
        this.dates.assertIsInSameSecondWindowAs(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInSameSecondWindowAs(String dateAsString) {
        return this.isInSameSecondWindowAs(this.parse(dateAsString));
    }

    public SELF isInSameSecondAs(Date other) {
        this.dates.assertIsInSameSecondAs(this.info, (Date)this.actual, other);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isInSameSecondAs(String dateAsString) {
        return this.isInSameSecondAs(this.parse(dateAsString));
    }

    public SELF isCloseTo(Date other, long deltaInMilliseconds) {
        this.dates.assertIsCloseTo(this.info, (Date)this.actual, other, deltaInMilliseconds);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF isCloseTo(String dateAsString, long deltaInMilliseconds) {
        return this.isCloseTo(this.parse(dateAsString), deltaInMilliseconds);
    }

    public SELF hasTime(long timestamp) {
        this.dates.assertHasTime(this.info, (Date)this.actual, timestamp);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF hasSameTimeAs(Date date) {
        this.dates.hasSameTimeAs(this.info, (Date)this.actual, date);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    public SELF hasSameTimeAs(String dateAsString) {
        this.dates.hasSameTimeAs(this.info, (Date)this.actual, this.parse(dateAsString));
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @CheckReturnValue
    public SELF withDateFormat(DateFormat userCustomDateFormat) {
        AbstractDateAssert.registerCustomDateFormat(userCustomDateFormat);
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @CheckReturnValue
    public SELF withDateFormat(String userCustomDateFormatPattern) {
        Preconditions.checkNotNull(userCustomDateFormatPattern, DATE_FORMAT_PATTERN_SHOULD_NOT_BE_NULL);
        return this.withDateFormat(new SimpleDateFormat(userCustomDateFormatPattern));
    }

    public static void setLenientDateParsing(boolean value) {
        ConfigurationProvider.loadRegisteredConfiguration();
        for (DateFormat defaultDateFormat : DEFAULT_DATE_FORMATS) {
            defaultDateFormat.setLenient(value);
        }
    }

    public static void registerCustomDateFormat(DateFormat userCustomDateFormat) {
        ConfigurationProvider.loadRegisteredConfiguration();
        Preconditions.checkNotNull(userCustomDateFormat, DATE_FORMAT_SHOULD_NOT_BE_NULL);
        userDateFormats.get().add(userCustomDateFormat);
    }

    public static void registerCustomDateFormat(String userCustomDateFormatPattern) {
        Preconditions.checkNotNull(userCustomDateFormatPattern, DATE_FORMAT_PATTERN_SHOULD_NOT_BE_NULL);
        AbstractDateAssert.registerCustomDateFormat(new SimpleDateFormat(userCustomDateFormatPattern));
    }

    public static void useDefaultDateFormatsOnly() {
        userDateFormats.get().clear();
    }

    @CheckReturnValue
    public SELF withDefaultDateFormatsOnly() {
        AbstractDateAssert.useDefaultDateFormatsOnly();
        return (SELF)((AbstractDateAssert)this.myself);
    }

    @VisibleForTesting
    Date parse(String dateAsString) {
        if (dateAsString == null) {
            return null;
        }
        Date date = this.parseDateWith(dateAsString, (Collection<DateFormat>)userDateFormats.get());
        if (date != null) {
            return date;
        }
        date = this.parseDateWithDefaultDateFormats(dateAsString);
        if (date != null) {
            return date;
        }
        throw new AssertionError((Object)String.format("Failed to parse %s with any of these date formats:%n   %s", dateAsString, this.info.representation().toStringOf(this.dateFormatsInOrderOfUsage())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parseDateWithDefaultDateFormats(String dateAsString) {
        List<DateFormat> list = DEFAULT_DATE_FORMATS;
        synchronized (list) {
            return this.parseDateWith(dateAsString, DEFAULT_DATE_FORMATS);
        }
    }

    private List<DateFormat> dateFormatsInOrderOfUsage() {
        ArrayList<DateFormat> allDateFormatsInOrderOfUsage = Lists.newArrayList((Iterable)userDateFormats.get());
        allDateFormatsInOrderOfUsage.addAll(DEFAULT_DATE_FORMATS);
        return allDateFormatsInOrderOfUsage;
    }

    private Date parseDateWith(String dateAsString, Collection<DateFormat> dateFormats) {
        for (DateFormat defaultDateFormat : dateFormats) {
            try {
                return defaultDateFormat.parse(dateAsString);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Date> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Date> customComparator, String customComparatorDescription) {
        this.dates = new Dates(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractDateAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.dates = Dates.instance();
        return (SELF)((AbstractDateAssert)super.usingDefaultComparator());
    }
}

