/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.extractor;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.extractor.ByNameSingleExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.util.Preconditions;

public class ByNameMultipleExtractor<T>
implements Function<T, Tuple> {
    private final String[] fieldsOrProperties;

    public ByNameMultipleExtractor(String ... fieldsOrProperties) {
        this.fieldsOrProperties = fieldsOrProperties;
    }

    @Override
    public Tuple apply(T input) {
        Preconditions.checkArgument(this.fieldsOrProperties != null, "The names of the fields/properties to read should not be null", new Object[0]);
        Preconditions.checkArgument(this.fieldsOrProperties.length > 0, "The names of the fields/properties to read should not be empty", new Object[0]);
        Preconditions.checkArgument(input != null, "The object to extract fields/properties from should not be null", new Object[0]);
        List<Function<T, Object>> extractors = this.buildExtractors();
        List<Object> values = this.extractValues(input, extractors);
        return new Tuple(values.toArray());
    }

    private List<Object> extractValues(T input, List<Function<T, Object>> singleExtractors) {
        return singleExtractors.stream().map(extractor -> extractor.apply(input)).collect(Collectors.toList());
    }

    private List<Function<T, Object>> buildExtractors() {
        return Arrays.stream(this.fieldsOrProperties).map(ByNameSingleExtractor::new).collect(Collectors.toList());
    }
}

