/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.op.StashApplyOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.handler.SelectionHandler;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class StashApplyHandler
extends SelectionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final RevCommit commit = this.getSelectedItem(RevCommit.class, event);
        if (commit == null) {
            return null;
        }
        Repository repo = this.getSelectedItem(Repository.class, event);
        if (repo == null) {
            return null;
        }
        final StashApplyOperation op = new StashApplyOperation(repo, commit);
        WorkspaceJob job = new WorkspaceJob(MessageFormat.format(UIText.StashApplyCommand_jobTitle, commit.name())){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                }
                catch (CoreException e) {
                    return new Status(4, Activator.getPluginId(), MessageFormat.format(UIText.StashApplyCommand_applyFailed, Utils.getShortObjectId((ObjectId)commit), e.getLocalizedMessage()), (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.STASH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }
}

