/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.object;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.access.object.AccessObject;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;

public class BranchAccessObject
extends AccessObject {
    private final BranchToken branch;
    private static final Map<BranchId, BranchAccessObject> cache = new HashMap<BranchId, BranchAccessObject>();

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.branch.hashCode();
        return result;
    }

    private BranchAccessObject(BranchToken branch) {
        super(branch);
        this.branch = branch;
    }

    @Override
    public BranchToken getBranch() {
        return this.branch;
    }

    @Override
    public void removeFromCache() {
        cache.remove(this.branch);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BranchAccessObject)) {
            return false;
        }
        return this.branch.equals(((BranchAccessObject)obj).branch);
    }

    @Override
    public boolean isBranch() {
        return true;
    }

    @Override
    public Long getId() {
        return this.branch.getId();
    }

    public static BranchAccessObject valueOf(BranchToken branch) {
        BranchAccessObject bao = cache.get(branch);
        if (bao == null) {
            bao = new BranchAccessObject(branch);
            cache.put(branch, bao);
        }
        return bao;
    }

    public String toString() {
        return "Branch  " + this.branch.toStringWithId();
    }
}

