/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;

public class ArchiveUnArchiveBranchJob
extends Job {
    private final BranchId branchId;
    private final BranchEndpoint branchEndpoint;
    private final ArchiveType archiveType;
    private Response response;

    public ArchiveUnArchiveBranchJob(String name, BranchId branchId, ArchiveType archiveType) {
        super(name);
        this.branchId = branchId;
        this.archiveType = archiveType;
        this.branchEndpoint = ServiceUtil.getOseeClient().getBranchEndpoint();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus toReturn = Status.CANCEL_STATUS;
        try {
            this.response = this.archiveType == ArchiveType.ARCHIVE ? this.branchEndpoint.archiveBranch(this.branchId) : this.branchEndpoint.unarchiveBranch(this.branchId);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)ex.getLocalizedMessage());
            return toReturn;
        }
        if (this.response.getStatus() == Response.Status.OK.getStatusCode()) {
            toReturn = Status.OK_STATUS;
        }
        return toReturn;
    }

    public Response getResponse() {
        return this.response;
    }

    public static enum ArchiveType {
        ARCHIVE,
        UNARCHIVE;

    }
}

