/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute.providers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.attribute.utils.AttributeResourceProcessor;

public class DataStore {
    private final AttributeResourceProcessor resourceProcessor;
    private String locator;
    private byte[] rawContent;
    private String contentType;
    private String encoding;
    private String extension;
    private boolean needToReadFromRemote;

    public DataStore(AttributeResourceProcessor resourceProcessor) {
        this.resourceProcessor = resourceProcessor;
        this.clear();
        this.needToReadFromRemote = true;
    }

    public String getLocator() {
        return this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
        this.needToReadFromRemote = true;
    }

    public boolean isLocatorValid() {
        return this.locator != null && this.locator.length() > 0;
    }

    public boolean isDataValid() {
        return this.rawContent != null && this.rawContent.length > 0;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getContent());
    }

    public byte[] getContent() {
        if (this.needToReadFromRemote && this.isLocatorValid()) {
            this.resourceProcessor.acquire(this);
            this.needToReadFromRemote = false;
        }
        return this.rawContent;
    }

    public void setContent(byte[] rawContent, String extension, String contentType, String encoding) {
        this.rawContent = rawContent;
        this.contentType = Strings.intern((String)contentType);
        this.encoding = Strings.intern((String)encoding);
        this.extension = Strings.intern((String)extension);
    }

    public void copyTo(DataStore other) {
        other.rawContent = Arrays.copyOf(this.rawContent, this.rawContent.length);
        other.contentType = Strings.intern((String)this.contentType);
        other.encoding = Strings.intern((String)this.encoding);
    }

    public void persist(GammaId storageId) {
        if (this.rawContent != null && this.rawContent.length > 0) {
            this.resourceProcessor.saveResource(storageId, this.resourceProcessor.createStorageName(), this);
        }
    }

    public void purge() {
        if (this.isLocatorValid()) {
            this.resourceProcessor.purge(this);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void clear() {
        this.setContent(null, "txt", "txt/plain", "UTF-8");
        this.setLocator(null);
    }

    public String getExtension() {
        return this.extension;
    }
}

