/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute.providers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.attribute.providers.AbstractAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.providers.DataStore;
import org.eclipse.osee.framework.skynet.core.attribute.providers.IBinaryAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.providers.ICharacterAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.utils.AttributeResourceProcessor;
import org.eclipse.osee.framework.skynet.core.attribute.utils.BinaryContentUtils;

public class UriAttributeDataProvider
extends AbstractAttributeDataProvider
implements ICharacterAttributeDataProvider,
IBinaryAttributeDataProvider {
    private final DataStore dataStore;
    private String displayable;

    public UriAttributeDataProvider(Attribute<?> attribute) {
        super(attribute);
        this.dataStore = new DataStore(new AttributeResourceProcessor(attribute));
        this.displayable = "";
    }

    @Override
    public String getDisplayableString() {
        return this.displayable;
    }

    @Override
    public void setDisplayableString(String toDisplay) {
        this.displayable = toDisplay;
    }

    private String getInternalFileName() {
        return BinaryContentUtils.generateFileName(this.getAttribute());
    }

    @Override
    public boolean setValue(ByteBuffer data) {
        boolean response = false;
        try {
            if (!Arrays.equals(this.dataStore.getContent(), data != null ? data.array() : null)) {
                if (data != null) {
                    byte[] compressed = Lib.compressStream((InputStream)Lib.byteBufferToInputStream((ByteBuffer)data), (String)this.getInternalFileName());
                    this.dataStore.setContent(compressed, "zip", "application/zip", "ISO-8859-1");
                    response = true;
                } else {
                    String loc = this.dataStore.getLocator();
                    this.dataStore.clear();
                    this.dataStore.setLocator(loc);
                }
            }
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return response;
    }

    @Override
    public ByteBuffer getValueAsBytes() {
        ByteBuffer decompressed = null;
        byte[] rawData = this.dataStore.getContent();
        if (rawData != null) {
            try {
                decompressed = ByteBuffer.wrap(Lib.decompressBytes((InputStream)new ByteArrayInputStream(rawData)));
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        return decompressed;
    }

    @Override
    public String getValueAsString() {
        String toReturn = null;
        ByteBuffer data = this.getValueAsBytes();
        if (data != null) {
            try {
                toReturn = new String(data.array(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        } else {
            toReturn = "";
        }
        return toReturn;
    }

    public boolean setValue(Object value) {
        ByteBuffer toSet = null;
        if (value != null && value instanceof String) {
            try {
                toSet = ByteBuffer.wrap(((String)value).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        this.setValue(toSet);
        return true;
    }

    @Override
    public Object[] getData() {
        return new Object[]{"", this.dataStore.getLocator()};
    }

    @Override
    public void loadData(Object ... objects) {
        if (objects != null && objects.length > 1) {
            this.dataStore.setLocator((String)objects[1]);
        }
    }

    @Override
    public void persist(GammaId storageId) {
        this.dataStore.persist(storageId);
    }

    @Override
    public void purge() {
        this.dataStore.purge();
    }

    @Override
    public Object getValue() {
        return this.getValueAsString();
    }
}

