/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.conflict;

import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.Adaptable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.enums.ConflictType;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.conflict.ConflictStatusManager;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public abstract class Conflict
implements Adaptable {
    protected ConflictStatus status;
    protected GammaId sourceGamma;
    protected GammaId destGamma;
    private final ArtifactId artId;
    private final TransactionToken toTransactionId;
    private final TransactionToken commitTransactionId;
    private Artifact artifact;
    private Artifact sourceArtifact;
    private Artifact destArtifact;
    protected BranchId mergeBranch;
    protected BranchToken sourceBranch;
    protected BranchToken destBranch;
    private String sourceDiffFile = null;
    private String destDiffFile = null;

    protected Conflict(GammaId sourceGamma, GammaId destGamma, ArtifactId artId, TransactionToken toTransactionId, TransactionToken commitTransactionId, BranchId mergeBranch, BranchToken sourceBranch, BranchToken destBranch) {
        this.sourceGamma = sourceGamma;
        this.destGamma = destGamma;
        this.artId = artId;
        this.toTransactionId = toTransactionId;
        this.sourceBranch = sourceBranch;
        this.destBranch = destBranch;
        this.mergeBranch = mergeBranch;
        this.commitTransactionId = commitTransactionId;
    }

    public Artifact getArtifact() {
        if (this.artifact == null) {
            this.artifact = ArtifactQuery.getArtifactFromId(this.artId, this.mergeBranch, DeletionFlag.INCLUDE_DELETED);
        }
        return this.artifact;
    }

    public Artifact getSourceArtifact() {
        if (this.sourceArtifact == null) {
            if (this.commitTransactionId == null) {
                this.sourceArtifact = ArtifactQuery.getArtifactFromId(this.artId, (BranchId)this.sourceBranch, DeletionFlag.INCLUDE_DELETED);
            } else {
                TransactionRecord baseTx = BranchManager.getBaseTransaction(this.mergeBranch);
                this.sourceArtifact = ArtifactQuery.getHistoricalArtifactFromId(this.artId, (TransactionToken)baseTx, DeletionFlag.INCLUDE_DELETED);
            }
        }
        return this.sourceArtifact;
    }

    public Artifact getDestArtifact() {
        if (this.destArtifact == null) {
            this.destArtifact = this.commitTransactionId == null ? ArtifactQuery.getArtifactFromId(this.artId, (BranchId)this.destBranch, DeletionFlag.INCLUDE_DELETED) : ArtifactQuery.getHistoricalArtifactFromId(this.artId, TransactionManager.getPriorTransaction(this.commitTransactionId), DeletionFlag.INCLUDE_DELETED);
        }
        return this.destArtifact;
    }

    public BranchId getMergeBranch() {
        return this.mergeBranch;
    }

    public BranchToken getSourceBranch() {
        return this.sourceBranch;
    }

    public BranchToken getDestBranch() {
        return this.destBranch;
    }

    public GammaId getSourceGamma() {
        return this.sourceGamma;
    }

    public void setSourceGamma(GammaId sourceGamma) {
        this.sourceGamma = sourceGamma;
    }

    public GammaId getDestGamma() {
        return this.destGamma;
    }

    public void setDestGamma(GammaId destGamma) {
        this.destGamma = destGamma;
    }

    public ArtifactId getArtId() {
        return this.artId;
    }

    public TransactionToken getToTransactionId() {
        return this.toTransactionId;
    }

    public TransactionToken getCommitTransactionId() {
        return this.commitTransactionId;
    }

    public abstract ConflictStatus computeStatus();

    protected ConflictStatus computeStatus(Id objectID, ConflictStatus defaultStatus) {
        ConflictStatus passedStatus = defaultStatus;
        try {
            if (this.sourceEqualsDestination() && this.mergeEqualsSource()) {
                passedStatus = ConflictStatus.RESOLVED;
            }
        }
        catch (AttributeDoesNotExist ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        TransactionRecord baseTx = BranchManager.getBaseTransaction(this.mergeBranch);
        this.status = ConflictStatusManager.computeStatus(this.sourceGamma, this.destGamma, this.mergeBranch, objectID, this.getConflictType().getValue(), passedStatus, (TransactionId)baseTx);
        return this.status;
    }

    public void setStatus(ConflictStatus status) {
        if (this.status.equals((Object)status)) {
            return;
        }
        ConflictStatusManager.setStatus(status, this.sourceGamma, this.destGamma, this.mergeBranch);
        this.status = status;
    }

    public String getArtifactName() {
        return this.getArtifact().getName();
    }

    public void handleResolvedSelection() throws Exception {
        if (this.status.equals((Object)ConflictStatus.EDITED)) {
            this.setStatus(ConflictStatus.RESOLVED);
        } else if (this.status.equals((Object)ConflictStatus.RESOLVED)) {
            this.setStatus(ConflictStatus.EDITED);
        } else if (this.status.equals((Object)ConflictStatus.OUT_OF_DATE_RESOLVED)) {
            this.setStatus(ConflictStatus.RESOLVED);
        } else if (this.status.equals((Object)ConflictStatus.OUT_OF_DATE)) {
            this.setStatus(ConflictStatus.EDITED);
        } else if (this.status.equals((Object)ConflictStatus.PREVIOUS_MERGE_APPLIED_SUCCESS)) {
            this.setStatus(ConflictStatus.RESOLVED);
        } else if (this.status.equals((Object)ConflictStatus.PREVIOUS_MERGE_APPLIED_CAUTION)) {
            this.setStatus(ConflictStatus.EDITED);
        }
    }

    public String getSourceDiffFile() {
        return this.sourceDiffFile;
    }

    public void setSourceDiffFile(String sourceDiffFile) {
        this.sourceDiffFile = sourceDiffFile;
    }

    public String getDestDiffFile() {
        return this.destDiffFile;
    }

    public void setDestDiffFile(String destDiffFile) {
        this.destDiffFile = destDiffFile;
    }

    public ConflictStatus getStatus() {
        return this.status;
    }

    public void computeEqualsValues() {
    }

    public abstract String getSourceDisplayData();

    public abstract String getDestDisplayData();

    public abstract boolean mergeEqualsSource();

    public abstract boolean mergeEqualsDestination();

    public abstract boolean sourceEqualsDestination();

    public abstract boolean setToSource(SkynetTransaction var1);

    public abstract boolean setToSource();

    public abstract boolean setToDest(SkynetTransaction var1);

    public abstract boolean setToDest();

    public abstract boolean clearValue();

    public abstract String getMergeDisplayData();

    public abstract String getChangeItem();

    public abstract ConflictType getConflictType();

    public abstract GammaId getMergeGammaId();

    public abstract Id getObjectId();

    public abstract boolean applyPreviousMerge(BranchId var1, BranchId var2);
}

