/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.httpRequests;

import java.util.Map;
import org.eclipse.osee.framework.core.client.server.HttpResponse;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.httpRequests.IClientLoopbackCmd;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public abstract class BaseArtifactLoopbackCmd
implements IClientLoopbackCmd {
    @Override
    public void execute(Map<String, String> parameters, HttpResponse httpResponse) {
        String branchUuid = parameters.get("branchUuid");
        String guid = parameters.get("guid");
        String id = parameters.get("id");
        boolean isDeleted = Boolean.valueOf(parameters.get("isDeleted"));
        DeletionFlag searchDeleted = isDeleted ? DeletionFlag.INCLUDE_DELETED : DeletionFlag.EXCLUDE_DELETED;
        String transactionIdStr = parameters.get("transactionId");
        boolean haveAValidBranchIdentifier = Strings.isValid((String)branchUuid);
        boolean haveAGuid = Strings.isValid((String)guid);
        boolean haveAnId = Strings.isValid((String)id);
        if (!haveAGuid && !haveAnId || !haveAValidBranchIdentifier) {
            httpResponse.outputStandardError(400, String.format("Unable to process [%s]", parameters));
        } else {
            try {
                Artifact artifact;
                BranchId branch;
                if (Strings.isValid((String)transactionIdStr)) {
                    TransactionToken transaction = TransactionManager.getTransaction(Long.valueOf(transactionIdStr));
                    branch = transaction.getBranch();
                    artifact = haveAGuid ? ArtifactQuery.getHistoricalArtifactFromId(guid, transaction, searchDeleted) : ArtifactQuery.getHistoricalArtifactFromId(ArtifactId.valueOf((String)id), transaction, searchDeleted);
                } else {
                    branch = BranchId.valueOf((String)branchUuid);
                    artifact = haveAGuid ? ArtifactQuery.getArtifactFromId(guid, branch, searchDeleted) : ArtifactQuery.getArtifactFromId(ArtifactId.valueOf((String)id), branch, searchDeleted);
                }
                if (artifact == null) {
                    httpResponse.outputStandardError(404, String.format("Artifact can not be found in OSEE on branch [%s]", branch));
                } else {
                    this.process(artifact, parameters, httpResponse);
                }
            }
            catch (Exception ex) {
                httpResponse.outputStandardError(500, String.format("Unable to process [%s]", parameters), (Throwable)ex);
            }
        }
    }

    @Override
    public abstract boolean isApplicable(String var1);

    @Override
    public abstract void process(Artifact var1, Map<String, String> var2, HttpResponse var3);
}

