/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.core.event.FrameworkEvent;
import org.eclipse.osee.framework.core.event.TopicEvent;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.ConnectionListener;
import org.eclipse.osee.framework.messaging.event.res.IFrameworkEventListener;
import org.eclipse.osee.framework.messaging.event.res.IOseeCoreModelEventService;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;
import org.eclipse.osee.framework.messaging.event.res.RemoteTopicEvent1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteBranchEvent1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteBroadcastEvent1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemotePersistEvent1;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteTransactionEvent1;
import org.eclipse.osee.framework.skynet.core.event.EventSystemPreferences;
import org.eclipse.osee.framework.skynet.core.event.OseeEventService;
import org.eclipse.osee.framework.skynet.core.event.listener.EventQosType;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.RemoteEventServiceEventType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEvent;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.event.ConnectionListenerImpl;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlers;
import org.eclipse.osee.framework.skynet.core.internal.event.EventListenerRegistry;
import org.eclipse.osee.framework.skynet.core.internal.event.EventTransport;
import org.eclipse.osee.framework.skynet.core.internal.event.OseeEventThreadFactory;
import org.eclipse.osee.framework.skynet.core.internal.event.TopicEventAdmin;
import org.eclipse.osee.framework.skynet.core.internal.event.handlers.ArtifactEventHandler;
import org.eclipse.osee.framework.skynet.core.internal.event.handlers.ArtifactRemoteEventHandler;
import org.eclipse.osee.framework.skynet.core.internal.event.handlers.BranchEventHandler;
import org.eclipse.osee.framework.skynet.core.internal.event.handlers.BranchRemoteEventHandler;
import org.eclipse.osee.framework.skynet.core.internal.event.handlers.RemoteServiceEventHandler;
import org.eclipse.osee.framework.skynet.core.internal.event.handlers.TopicLocalEventHandler;
import org.eclipse.osee.framework.skynet.core.internal.event.handlers.TopicRemoteEventHandler;
import org.eclipse.osee.framework.skynet.core.internal.event.handlers.TransactionEventHandler;
import org.eclipse.osee.framework.skynet.core.internal.event.handlers.TransactionRemoteEventHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OseeEventServiceImpl
implements OseeEventService {
    private final EventSystemPreferences preferences;
    private final EventListenerRegistry listeners;
    private final EventHandlers handlers;
    private IOseeCoreModelEventService messagingService;
    private EventTransport eventTransport;
    private ConnectionListenerImpl connectionStatus;
    private ExecutorService executor;
    private OrcsTokenService tokenService;
    private final List<ServiceReference<IEventListener>> pendingServices = new CopyOnWriteArrayList<ServiceReference<IEventListener>>();
    private Thread thread;

    public OseeEventServiceImpl() {
        this.handlers = new EventHandlers();
        this.preferences = Activator.getEventPreferences();
        this.listeners = Activator.getEventListeners();
    }

    public void setOrcsTokenService(OrcsTokenService tokenService) {
        this.tokenService = tokenService;
    }

    public void setOseeCoreModelEventService(IOseeCoreModelEventService messagingService) {
        this.messagingService = messagingService;
    }

    public void addListener(ServiceReference<IEventListener> reference) {
        if (this.isReady()) {
            this.registerListener(reference);
        } else {
            this.pendingServices.add(reference);
        }
    }

    public void removeListener(ServiceReference<IEventListener> reference) {
        if (this.isReady()) {
            this.unregisterListener(reference);
        } else {
            this.pendingServices.remove(reference);
        }
    }

    private void registerListener(ServiceReference<IEventListener> reference) {
        IEventListener listener = this.getService(reference);
        EventQosType qos = this.getEventQosType(reference);
        EventUtil.eventLog((String)"registering event listener - name[%s]", (Object[])new Object[]{reference.getProperty("component.name")});
        this.addListener(qos, listener);
    }

    private void unregisterListener(ServiceReference<IEventListener> reference) {
        IEventListener listener = this.getService(reference);
        EventQosType qos = this.getEventQosType(reference);
        EventUtil.eventLog((String)"deregistering event listener - name[%s]", (Object[])new Object[]{reference.getProperty("component.name")});
        this.removeListener(qos, listener);
    }

    private IEventListener getService(ServiceReference<IEventListener> reference) {
        Bundle bundle = reference.getBundle();
        BundleContext context = bundle.getBundleContext();
        IEventListener listener = (IEventListener)context.getService(reference);
        return listener;
    }

    private boolean isReady() {
        return this.eventTransport != null;
    }

    public void start() {
        this.registerEventHandlers(this.handlers);
        this.executor = this.createExecutor("Osee Client Events");
        this.listeners.addListener(EventQosType.PRIORITY, new TopicEventAdmin());
        this.eventTransport = new EventTransport(this.preferences, this.handlers, this.listeners, this.executor, this.messagingService);
        this.connectionStatus = new ConnectionListenerImpl(this.preferences, this.eventTransport);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (ServiceReference<IEventListener> reference : OseeEventServiceImpl.this.pendingServices) {
                    OseeEventServiceImpl.this.registerListener(reference);
                }
                OseeEventServiceImpl.this.pendingServices.clear();
                try {
                    OseeEventServiceImpl.this.messagingService.addConnectionListener((ConnectionListener)OseeEventServiceImpl.this.connectionStatus);
                    OseeEventServiceImpl.this.messagingService.addFrameworkListener((IFrameworkEventListener)OseeEventServiceImpl.this.eventTransport);
                    OseeEventServiceImpl.this.eventTransport.send(this, RemoteEventServiceEventType.Rem_Connected);
                }
                catch (OseeCoreException ex) {
                    OseeEventServiceImpl.this.eventTransport.setConnected(false);
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        };
        this.thread = new Thread(runnable);
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        if (this.connectionStatus != null) {
            this.messagingService.removeConnectionListener((ConnectionListener)this.connectionStatus);
            this.connectionStatus = null;
        }
        if (this.eventTransport != null) {
            this.eventTransport.setConnected(false);
            this.messagingService.removeFrameworkListener((IFrameworkEventListener)this.eventTransport);
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.deregisterEventHandlers(this.handlers);
        this.eventTransport = null;
    }

    private EventQosType getEventQosType(ServiceReference<IEventListener> reference) {
        EventQosType type = EventQosType.NORMAL;
        String value = (String)reference.getProperty("qos");
        if (Strings.isValid((String)value)) {
            EventQosType[] eventQosTypeArray = EventQosType.values();
            int n = eventQosTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventQosType qosType = eventQosTypeArray[n2];
                if (qosType.name().equalsIgnoreCase(value)) {
                    type = qosType;
                    break;
                }
                ++n2;
            }
        }
        return type;
    }

    private void registerEventHandlers(EventHandlers handlers) {
        handlers.addLocalHandler(ArtifactEvent.class, new ArtifactEventHandler());
        handlers.addLocalHandler(BranchEvent.class, new BranchEventHandler());
        handlers.addLocalHandler(RemoteEventServiceEventType.class, new RemoteServiceEventHandler());
        handlers.addLocalHandler(TransactionEvent.class, new TransactionEventHandler());
        handlers.addLocalHandler(TopicEvent.class, new TopicLocalEventHandler());
        handlers.addRemoteHandler(RemotePersistEvent1.class, new ArtifactRemoteEventHandler(this.tokenService));
        handlers.addRemoteHandler(RemoteBranchEvent1.class, new BranchRemoteEventHandler());
        handlers.addRemoteHandler(RemoteTransactionEvent1.class, new TransactionRemoteEventHandler(this.tokenService));
        handlers.addRemoteHandler(RemoteTopicEvent1.class, new TopicRemoteEventHandler());
    }

    private void deregisterEventHandlers(EventHandlers handlers) {
        handlers.removeLocalHandler(ArtifactEvent.class);
        handlers.removeLocalHandler(BranchEvent.class);
        handlers.removeLocalHandler(RemoteEventServiceEventType.class);
        handlers.removeLocalHandler(TransactionEvent.class);
        handlers.removeLocalHandler(TopicEvent.class);
        handlers.removeRemoteHandler(RemotePersistEvent1.class);
        handlers.removeRemoteHandler(RemoteBranchEvent1.class);
        handlers.removeRemoteHandler(RemoteBroadcastEvent1.class);
        handlers.removeRemoteHandler(RemoteTransactionEvent1.class);
        handlers.removeRemoteHandler(RemoteTopicEvent1.class);
    }

    private ExecutorService createExecutor(String threadPrefix) {
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        if (numberOfProcessors > 4) {
            numberOfProcessors = 4;
        }
        OseeEventThreadFactory threadFactory = new OseeEventThreadFactory(threadPrefix);
        return Executors.newFixedThreadPool(numberOfProcessors, threadFactory);
    }

    @Override
    public boolean isConnected() {
        return this.eventTransport.isConnected();
    }

    @Override
    public <E extends FrameworkEvent> void send(Object object, E event) {
        this.eventTransport.send(object, event);
    }

    @Override
    public <E extends RemoteEvent> void receive(E event) {
        this.eventTransport.onEvent(event);
    }

    @Override
    public <E extends FrameworkEvent> void receive(Sender sender, E event) {
        this.eventTransport.sendLocal(sender, event);
    }

    @Override
    public void addListener(EventQosType qos, IEventListener listener) {
        this.listeners.addListener(qos, listener);
    }

    @Override
    public void removeListener(EventQosType qos, IEventListener listener) {
        this.listeners.removeListener(qos, listener);
    }

    @Override
    public void sendCommitEvent(Class<?> class1, ArtifactEvent artifactEvent) {
        this.eventTransport.sendCommitEvent(class1, artifactEvent);
    }
}

