/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.revision;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.model.TransactionDelta;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.change.ArtifactDelta;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.revision.ChangeDataLoader;
import org.eclipse.osee.framework.skynet.core.revision.RevisionChangeLoader;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.skynet.core.utility.Id4JoinQuery;
import org.eclipse.osee.framework.skynet.core.utility.JoinUtility;
import org.eclipse.osee.jdbc.JdbcStatement;

public final class ChangeManager {
    private static final RevisionChangeLoader revsionChangeLoader = new RevisionChangeLoader();

    private ChangeManager() {
    }

    public static Collection<ArtifactDelta> getCompareArtifacts(Collection<Change> changes) {
        ArrayList<ArtifactDelta> toReturn = new ArrayList<ArtifactDelta>(changes.size());
        for (Change change : changes) {
            toReturn.add(change.getDelta());
        }
        return toReturn;
    }

    public static Collection<Change> getChangesPerArtifact(Artifact artifact, IProgressMonitor monitor) {
        return revsionChangeLoader.getChangesPerArtifact(artifact, monitor, ChangeType.Artifact, ChangeType.Attribute, ChangeType.Relation);
    }

    public static Collection<Change> getChangesPerArtifact(Artifact artifact, IProgressMonitor monitor, ChangeType ... loadChangeTypes) {
        return revsionChangeLoader.getChangesPerArtifact(artifact, monitor, loadChangeTypes);
    }

    public static Collection<? extends Change> getChangesPerArtifact(Artifact artifact, int numberTransactionsToShow, IProgressMonitor monitor) {
        return revsionChangeLoader.getChangesPerArtifact(artifact, numberTransactionsToShow, monitor, ChangeType.Artifact, ChangeType.Attribute, ChangeType.Relation);
    }

    public static IOperation comparedToPreviousTx(TransactionToken transactionId, Collection<Change> changes) {
        TransactionToken startTx = TransactionManager.getPriorTransaction(transactionId);
        TransactionToken endTx = transactionId;
        TransactionDelta txDelta = new TransactionDelta(startTx, endTx);
        return new ChangeDataLoader(changes, txDelta);
    }

    public static IOperation comparedToParent(BranchId branch, Collection<Change> changes) {
        TransactionToken startTx = TransactionManager.getHeadTransaction(branch);
        TransactionToken endTx = TransactionManager.getHeadTransaction((BranchId)BranchManager.getParentBranch(branch));
        TransactionDelta txDelta = new TransactionDelta(startTx, endTx);
        return new ChangeDataLoader(changes, txDelta);
    }

    public static IOperation compareTwoBranchesHead(BranchId sourceBranch, BranchId destinationBranch, Collection<Change> changes) {
        TransactionToken startTx = TransactionManager.getHeadTransaction(sourceBranch);
        TransactionToken endTx = TransactionManager.getHeadTransaction(destinationBranch);
        return new ChangeDataLoader(changes, new TransactionDelta(startTx, endTx));
    }

    public static HashCollection<Artifact, TransactionId> getModifingTransactions(Collection<Artifact> artifacts) {
        HashCollection transactionMap = new HashCollection();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Id4JoinQuery joinQuery = JoinUtility.createId4JoinQuery();){
            CompositeKeyHashMap artifactMap = new CompositeKeyHashMap();
            for (Artifact artifact : artifacts) {
                BranchToken branch = artifact.getBranch();
                artifactMap.put((Object)artifact.getId(), (Object)branch, (Object)artifact);
                TransactionToken transaction = TransactionManager.getHeadTransaction((BranchId)branch);
                joinQuery.add((Id)branch, (Id)artifact, (Id)transaction, (Id)branch.getViewId());
                while (branch.notEqual((Id)CoreBranches.SYSTEM_ROOT)) {
                    transaction = BranchManager.getSourceTransaction((BranchId)branch);
                    branch = BranchManager.getParentBranch((BranchId)branch);
                    joinQuery.add((Id)branch, (Id)artifact, (Id)transaction);
                }
            }
            joinQuery.store();
            try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
                chStmt.runPreparedQuery(joinQuery.size() * 2, ServiceUtil.getSql(OseeSql.CHANGE_TX_MODIFYING), new Object[]{joinQuery.getQueryId()});
                while (chStmt.next()) {
                    BranchId branch = BranchId.valueOf((Long)chStmt.getLong("branch_id"));
                    Artifact artifact = (Artifact)((Object)artifactMap.get((Object)chStmt.getLong("art_id"), (Object)branch));
                    transactionMap.put((Object)artifact, (Object)TransactionId.valueOf((Long)chStmt.getLong("transaction_id")));
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return transactionMap;
    }

    public static HashCollection<Artifact, BranchId> getModifingBranches(Collection<Artifact> artifacts) {
        HashCollection branchMap = new HashCollection();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Id4JoinQuery joinQuery = JoinUtility.createId4JoinQuery();){
            CompositeKeyHashMap artifactMap = new CompositeKeyHashMap();
            for (Artifact artifact : artifacts) {
                artifactMap.put((Object)artifact.getId(), (Object)artifact.getBranch(), (Object)artifact);
                for (BranchId branchId : BranchManager.getBranches(BranchArchivedState.UNARCHIVED, BranchType.WORKING)) {
                    if (!artifact.isOnBranch((BranchId)BranchManager.getParentBranch(branchId))) continue;
                    joinQuery.add((Id)branchId, (Id)artifact, (Id)TransactionId.SENTINEL, (Id)branchId.getViewId());
                }
            }
            joinQuery.store();
            try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
                chStmt.runPreparedQuery(joinQuery.size() * 2, ServiceUtil.getSql(OseeSql.CHANGE_BRANCH_MODIFYING), new Object[]{joinQuery.getQueryId()});
                while (chStmt.next()) {
                    if (chStmt.getInt("tx_count") <= 0) continue;
                    BranchId branch = BranchId.valueOf((Long)chStmt.getLong("branch_id"));
                    Artifact artifact = (Artifact)((Object)artifactMap.get((Object)chStmt.getLong("art_id"), (Object)BranchManager.getParentBranch(branch)));
                    branchMap.put((Object)artifact, (Object)branch);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return branchMap;
    }
}

