/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.transaction;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.skynet.core.transaction.TxMonitor;
import org.eclipse.osee.framework.skynet.core.transaction.TxMonitorImpl;

public abstract class TransactionOperation<K>
extends AbstractOperation
implements TxMonitorImpl.MonitoredTx {
    private final TxMonitor<K> txMonitor;
    private final K key;
    private final String uuid;
    private volatile TxMonitorImpl.TxState state;

    protected TransactionOperation(TxMonitor<K> txMonitor, K key, String description) {
        super(description, "org.eclipse.osee.framework.skynet.core");
        this.txMonitor = txMonitor;
        this.key = key;
        this.uuid = GUID.create();
        this.setTxState(TxMonitorImpl.TxState.CREATED);
    }

    protected abstract void clear();

    protected abstract void txWork(IProgressMonitor var1) throws Exception;

    protected TxMonitor<K> getTxMonitor() {
        return this.txMonitor;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    protected K getKey() {
        return this.key;
    }

    protected void setTxState(TxMonitorImpl.TxState state) {
        this.state = state;
    }

    @Override
    public TxMonitorImpl.TxState getTxState() {
        return this.state;
    }

    protected void ensureCanBeAdded(Object object) {
        this.txMonitor.checkForComodification(this.getKey(), this, object);
    }

    @Override
    public abstract boolean containsItem(Object var1);

    @Override
    public void rollback() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doWork(IProgressMonitor monitor) throws Exception {
        TxMonitor<K> txMonitor = this.txMonitor;
        synchronized (txMonitor) {
            try {
                try {
                    this.txMonitor.beginTx(this.getKey(), this);
                    if (this.getTxState() == TxMonitorImpl.TxState.MODIFIED) {
                        this.setTxState(TxMonitorImpl.TxState.RUNNING);
                        this.txWork((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    }
                    this.setTxState(TxMonitorImpl.TxState.ENDED);
                }
                catch (Exception ex) {
                    this.setTxState(TxMonitorImpl.TxState.ENDED_WITH_EXCEPTION);
                    this.txMonitor.rollbackTx(this.getKey(), this);
                    throw ex;
                }
            }
            finally {
                try {
                    this.txMonitor.endTx(this.getKey(), this);
                }
                finally {
                    this.clear();
                }
            }
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TxMonitorImpl.MonitoredTx other = (TxMonitorImpl.MonitoredTx)obj;
        return !(this.uuid == null ? other.getUuid() != null : !this.uuid.equals(other.getUuid()));
    }
}

