/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal.activemq;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.messaging.internal.JAXBUtil;

class ActiveMqUtil {
    ActiveMqUtil() {
    }

    Object translateMessage(Message message, Class<?> clazz) throws JMSException {
        Object messageBody = message;
        if (message instanceof TextMessage) {
            String text = ((TextMessage)message).getText();
            if (clazz != null) {
                try {
                    messageBody = JAXBUtil.unmarshal(text, clazz);
                }
                catch (Exception ex) {
                    throw new OseeCoreException(ex.getCause(), "Unmarshal exception for text [%s] and class [%s]", new Object[]{text, clazz});
                }
            } else {
                messageBody = text;
            }
        } else if (message instanceof BytesMessage) {
            int length = (int)((BytesMessage)message).getBodyLength();
            byte[] bytes = new byte[length];
            ((BytesMessage)message).readBytes(bytes);
            messageBody = bytes;
        } else if (message instanceof ObjectMessage) {
            messageBody = ((ObjectMessage)message).getObject();
        }
        return messageBody;
    }

    Message createMessage(Session session, Class<?> clazz, Object body) throws JMSException {
        if ((body = this.tryToGetSerialized(clazz, body)) instanceof String) {
            return session.createTextMessage((String)body);
        }
        if (body instanceof byte[]) {
            BytesMessage byteMessage = session.createBytesMessage();
            byteMessage.writeBytes((byte[])body);
            return byteMessage;
        }
        if (body instanceof Serializable) {
            return session.createObjectMessage((Serializable)body);
        }
        throw new OseeCoreException("Unsupported java type [%s]", new Object[]{body.getClass().getName()});
    }

    private Object tryToGetSerialized(Class<?> clazz, Object body) {
        if (clazz != null) {
            try {
                return JAXBUtil.marshal(body);
            }
            catch (UnsupportedEncodingException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        return body;
    }
}

