/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal.activemq;

import java.util.logging.Level;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.OseeMessagingStatusCallback;
import org.eclipse.osee.framework.messaging.ReplyConnection;
import org.eclipse.osee.framework.messaging.internal.Activator;
import org.eclipse.osee.framework.messaging.internal.activemq.ActiveMqUtil;

class ReplyConnectionActiveMqImpl
implements ReplyConnection {
    private final boolean isReplyRequested;
    private MessageProducer producer;
    private Destination destReply;
    private String correlationId;
    private Session session;
    private ActiveMqUtil activeMqUtil;

    ReplyConnectionActiveMqImpl(ActiveMqUtil activeMqUtil, Session session, MessageProducer producer, Destination destReply, String correlationId) {
        this.isReplyRequested = true;
        this.producer = producer;
        this.destReply = destReply;
        this.correlationId = correlationId;
        this.session = session;
        this.activeMqUtil = activeMqUtil;
    }

    ReplyConnectionActiveMqImpl() {
        this.isReplyRequested = false;
    }

    @Override
    public boolean isReplyRequested() {
        return this.isReplyRequested;
    }

    @Override
    public void send(Object body, Class<?> clazz, OseeMessagingStatusCallback statusCallback) {
        try {
            Message message = this.activeMqUtil.createMessage(this.session, clazz, body);
            message.setJMSCorrelationID(this.correlationId);
            this.producer.send(this.destReply, message);
            OseeLog.logf(Activator.class, (Level)Level.INFO, (String)"Sending Reply Message %s", (Object[])new Object[]{message.toString()});
        }
        catch (JMSException ex) {
            statusCallback.fail(ex);
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }
}

