/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.rules;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;

public class HushHtmlScriptErrors
extends Rule {
    private static final String HUSH = "\nfunction handleError() {\nreturn true;\n}\n\nwindow.onerror = handleError;\n";

    public HushHtmlScriptErrors() {
        super(null);
        this.setFileNamePattern(".*\\.html");
    }

    @Override
    public ChangeSet computeChanges(CharSequence seq) {
        Matcher matcher;
        Pattern detectHusherInPlace = Pattern.compile("function handleError");
        Pattern findJavaScriptArea = Pattern.compile("<SCRIPT type=\"text/javascript\">");
        ChangeSet changeSet = new ChangeSet(seq);
        Matcher matchHusher = detectHusherInPlace.matcher(seq);
        if (!matchHusher.find() && (matcher = findJavaScriptArea.matcher(seq)).find()) {
            this.ruleWasApplicable = true;
            changeSet.insertBefore(matcher.end() + 1, HUSH);
        }
        return changeSet;
    }

    public static void main(String[] args) {
        HushHtmlScriptErrors hushRule = new HushHtmlScriptErrors();
        int i = 0;
        while (i < args.length) {
            try {
                System.out.print("File " + (i + 1) + "/" + args.length + ":");
                hushRule.process(new File(args[i]));
            }
            catch (Exception ex) {
                System.out.println("Exception in Rule!!! " + hushRule.getCurrentOutfileName() + ": " + ex.getMessage());
                ex.printStackTrace();
            }
            ++i;
        }
        System.out.println("Finished");
    }
}

