/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.rules;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;

public class InsertTypeGuids
extends Rule {
    private static final Pattern classDeclarationP = Pattern.compile("Type \"([^\"]*)\".*?\\{\\s*");
    private static final Map<String, String> typeGuids = new HashMap<String, String>();

    public InsertTypeGuids() {
        super(null);
        this.setFileNamePattern(".*\\.osee");
        typeGuids.put("Phone", "AAMFEbUkVSwKu4LSpWAA");
        typeGuids.put("Mobile Phone", "AAMFEbWi7AIC1z82PxQA");
    }

    @Override
    public ChangeSet computeChanges(CharSequence seq) {
        ChangeSet changeSet = new ChangeSet(seq);
        Matcher matcher = classDeclarationP.matcher(seq);
        while (matcher.find()) {
            this.setRuleWasApplicable(true);
            String typeName = matcher.group(1);
            String typeGuid = typeGuids.get(typeName);
            if (typeGuid == null) {
                if (typeName.contains(".enum") || typeName.contains("demo") || typeName.contains("Demo")) continue;
                System.out.println(String.format("%s => %s", typeName, typeGuid));
                continue;
            }
            String ins = String.format("typeGuid \"%s\"\r\n\t", typeGuid);
            changeSet.insertBefore(matcher.end(), ins);
        }
        return changeSet;
    }
}

