/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.Triplet;

public class CompositeKeyTripleHashMap<KeyOne, KeyTwo, KeyThree, Value>
implements Map<Triplet<KeyOne, KeyTwo, KeyThree>, Value> {
    private final Map<Triplet<KeyOne, KeyTwo, KeyThree>, Value> map;
    private final ThreadLocal<Triplet<KeyOne, KeyTwo, KeyThree>> threadLocalKey = new ThreadLocal<Triplet<KeyOne, KeyTwo, KeyThree>>(){

        @Override
        protected Triplet<KeyOne, KeyTwo, KeyThree> initialValue() {
            return new Triplet<Object, Object, Object>(null, null, null);
        }
    };

    public CompositeKeyTripleHashMap() {
        this.map = new HashMap<Triplet<KeyOne, KeyTwo, KeyThree>, Value>();
    }

    public CompositeKeyTripleHashMap(Map<Triplet<KeyOne, KeyTwo, KeyThree>, Value> map) {
        this.map = map;
    }

    public CompositeKeyTripleHashMap(int initialCapacity) {
        this.map = new HashMap<Triplet<KeyOne, KeyTwo, KeyThree>, Value>(initialCapacity);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsKey(KeyOne a, KeyTwo b, KeyThree c) {
        return this.map.containsKey(this.threadLocalKey.get().set(a, b, c));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Triplet<KeyOne, KeyTwo, KeyThree>, Value>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Value get(Object key) {
        if (Triplet.class.isInstance(key)) {
            return this.map.get(key);
        }
        throw new IllegalArgumentException(String.format("Expected Type [CompositeKey], got type [%s].", key.getClass().getName()));
    }

    public Value get(KeyOne a, KeyTwo b, KeyThree c) {
        return this.map.get(this.threadLocalKey.get().set(a, b, c));
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Triplet<KeyOne, KeyTwo, KeyThree>> keySet() {
        return this.map.keySet();
    }

    @Override
    public Value put(Triplet<KeyOne, KeyTwo, KeyThree> key, Value value) {
        return this.map.put(key, value);
    }

    public Value put(KeyOne a, KeyTwo b, KeyThree c, Value value) {
        return this.map.put(new Triplet<KeyOne, KeyTwo, KeyThree>(a, b, c), value);
    }

    @Override
    public void putAll(Map<? extends Triplet<KeyOne, KeyTwo, KeyThree>, ? extends Value> m) {
        this.map.putAll(m);
    }

    @Override
    public Value remove(Object key) {
        return this.map.remove(key);
    }

    public Value remove(KeyOne a, KeyTwo b, KeyThree c) {
        return this.map.remove(this.threadLocalKey.get().set(a, b, c));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Value> values() {
        return this.map.values();
    }
}

