/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

public class Field {
    private final boolean isPublic;
    private final boolean isFinal;
    private final boolean isStatic;
    private final String type;
    private final String name;
    private final String initialValue;

    public Field(String type, String name, boolean isFinal) {
        this(type, name, false, false, isFinal);
    }

    public Field(String type, String name, boolean isPublic, boolean isStatic, boolean isFinal) {
        this(type, name, isPublic, isStatic, isFinal, null);
    }

    public Field(String type, String name, boolean isPublic, boolean isStatic, boolean isFinal, String initialValue) {
        this.type = type;
        this.name = name;
        this.isPublic = isPublic;
        this.isStatic = isStatic;
        this.isFinal = isFinal;
        this.initialValue = initialValue;
    }

    public String toString() {
        String declaration = "\t" + (this.isPublic ? "public " : "private ") + (this.isStatic ? "static " : "") + (this.isFinal ? "final " : "") + this.type + " " + this.name;
        if (this.initialValue != null) {
            declaration = String.valueOf(declaration) + " = " + this.initialValue;
        }
        return String.valueOf(declaration) + ";";
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }
}

