/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.BufferedReader;
import java.io.Writer;
import java.util.concurrent.Callable;

public final class OutputRedirector
implements Callable<Long> {
    private final Writer output;
    private final BufferedReader input;

    public OutputRedirector(Writer output, BufferedReader input) {
        this.output = output;
        this.input = input;
    }

    @Override
    public Long call() throws Exception {
        long totalBytes = 0L;
        try {
            int size;
            char[] buffer = new char[4096];
            while ((size = this.input.read(buffer)) != -1) {
                totalBytes += (long)size;
                this.output.write(buffer, 0, size);
                this.output.flush();
            }
        }
        finally {
            this.input.close();
        }
        return totalBytes;
    }
}

