/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Jaxp {
    private static final DocumentBuilderFactory namespceUnawareFactory = DocumentBuilderFactory.newInstance();
    private static final DocumentBuilderFactory NonDeferredNamespceUnawareFactory = DocumentBuilderFactory.newInstance();
    private static final DocumentBuilderFactory namespceAwareFactory = DocumentBuilderFactory.newInstance();

    static {
        namespceAwareFactory.setNamespaceAware(true);
    }

    public static List<Element> getChildDirects(Element element) {
        NodeList nl = element.getChildNodes();
        ArrayList<Element> elementList = new ArrayList<Element>(nl.getLength());
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                elementList.add((Element)n);
            }
            ++i;
        }
        return elementList;
    }

    public static List<Element> getChildDirects(Element element, String childTagName) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && ((Element)n).getTagName().equals(childTagName)) {
                elementList.add((Element)n);
            }
            ++i;
        }
        return elementList;
    }

    public static Element getChildDirect(Element element, String childTagName) {
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && ((Element)n).getTagName().equals(childTagName)) {
                return (Element)n;
            }
            ++i;
        }
        return null;
    }

    public static Element getChild(Element element, String childTagName) {
        NodeList elementList = element.getElementsByTagName(childTagName);
        return (Element)elementList.item(0);
    }

    public static Element createElement(Document d, String tag, String characterData) {
        Element e = d.createElement(tag);
        e.setTextContent(characterData);
        return e;
    }

    public static String getElementCharacterData(Element e, boolean trimWhitespace) {
        NodeList childNodes = e.getChildNodes();
        StringBuilder resultString = new StringBuilder();
        boolean first = true;
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeType() == 3) {
                if (!first && trimWhitespace) {
                    resultString.append(" ");
                }
                resultString.append(trimWhitespace ? n.getNodeValue().trim() : n.getNodeValue());
                first = false;
            } else if (n.getNodeType() == 4) {
                if (!first && trimWhitespace) {
                    resultString.append(" ");
                }
                resultString.append(trimWhitespace ? n.getNodeValue().trim() : n.getNodeValue());
                first = false;
            }
            ++i;
        }
        return resultString.toString();
    }

    public static String getElementCharacterData(Element e) {
        return Jaxp.getElementCharacterData(e, true);
    }

    public static List<String> getElementsCharacterData(Collection<Element> elements) {
        ArrayList<String> result = new ArrayList<String>(elements.size());
        for (Element e : elements) {
            result.add(Jaxp.getElementCharacterData(e));
        }
        return result;
    }

    public static ArrayList<String> getChildrenTexts(NodeList nodes) {
        ArrayList<String> retVal = new ArrayList<String>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Element element = (Element)nodes.item(i);
            retVal.add(Jaxp.getElementCharacterData(element));
            ++i;
        }
        return retVal;
    }

    public static ArrayList<String> getChildrenTexts(Document document, String tagName) {
        return Jaxp.getChildrenTexts(document.getElementsByTagName(tagName));
    }

    public static ArrayList<String> getChildrenTexts(Element element, String tagName) {
        return Jaxp.getChildrenTexts(element.getElementsByTagName(tagName));
    }

    public static String getChildText(Element element, String childTagName, boolean trim) {
        Element child = Jaxp.getChild(element, childTagName);
        if (child != null) {
            return Jaxp.getElementCharacterData(child, trim);
        }
        return null;
    }

    public static String getChildText(Element element, String childTagName) {
        return Jaxp.getChildText(element, childTagName, false);
    }

    public static String getChildTextTrim(Element element, String childTagName) {
        return Jaxp.getChildText(element, childTagName, true);
    }

    private static void findElementsInternal(List<Element> source, LinkedList<String> path, List<Element> list) {
        String tag = path.poll();
        LinkedList<String> childPath = new LinkedList<String>(path);
        for (Element e : source) {
            List<Element> children = Jaxp.getChildDirects(e, tag);
            if (children.isEmpty()) continue;
            if (path.isEmpty()) {
                list.addAll(children);
                continue;
            }
            Jaxp.findElementsInternal(children, childPath, list);
        }
    }

    public static List<Element> findElements(Element element, List<String> elementPath, boolean firstIsRoot) {
        LinkedList<Element> result = new LinkedList<Element>();
        ArrayList<Element> source = new ArrayList<Element>(1);
        source.add(element);
        LinkedList<String> path = elementPath instanceof LinkedList ? (LinkedList<String>)elementPath : new LinkedList<String>(elementPath);
        if (firstIsRoot) {
            String firstTagName = path.poll();
            if (element.getTagName().equals(firstTagName)) {
                return result;
            }
        }
        Jaxp.findElementsInternal(source, path, result);
        return result;
    }

    private static List<Element> findElementsSinglePath(Element e, String elementPath, boolean firstIsRoot) {
        return Jaxp.findElements(e, Collections.fromString(elementPath, "/"), firstIsRoot);
    }

    private static List<Element> findElements(Element e, String elementPath, boolean firstIsRoot) {
        String[] paths;
        LinkedList<Element> result = new LinkedList<Element>();
        String[] stringArray = paths = elementPath.split("\\|");
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            result.addAll(Jaxp.findElementsSinglePath(e, path, firstIsRoot));
            ++n2;
        }
        return result;
    }

    public static List<Element> findElements(Element element, String elementPath) {
        return Jaxp.findElements(element, elementPath, false);
    }

    public static List<Element> findElements(Document d, String elementPath) {
        return Jaxp.findElements(d.getDocumentElement(), elementPath, true);
    }

    public static Element findElement(Element element, List<String> elementPath) {
        Element e = element;
        for (String tag : elementPath) {
            NodeList a = e.getChildNodes();
            Element nextElement = null;
            int i = 0;
            while (i < a.getLength() && nextElement == null) {
                Node n = a.item(i);
                if (n.getNodeType() == 1 && ((Element)n).getTagName().equals(tag)) {
                    nextElement = (Element)n;
                }
                ++i;
            }
            if (nextElement == null) {
                return null;
            }
            e = nextElement;
        }
        return e;
    }

    public static Element findElement(Document d, String elementPath) {
        List<String> pathList = Arrays.asList(elementPath.split("/"));
        String rootTagName = pathList.get(0);
        if (pathList.size() > 1) {
            pathList = pathList.subList(1, pathList.size());
        } else {
            pathList.clear();
        }
        Element root = d.getDocumentElement();
        if (!root.getTagName().equals(rootTagName)) {
            return null;
        }
        return Jaxp.findElement(d.getDocumentElement(), pathList);
    }

    public static Element findElement(Element e, String elementPath) {
        return Jaxp.findElement(e, Arrays.asList(elementPath.split("/")));
    }

    public static Document readXmlDocument(InputStream is, String encoding) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(is);
        inputSource.setEncoding(encoding);
        DocumentBuilder builder = namespceUnawareFactory.newDocumentBuilder();
        return builder.parse(inputSource);
    }

    public static Document nonDeferredreadXmlDocument(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        return Jaxp.nonDeferredReadXmlDocument(Lib.stringToInputStream(xmlString), "UTF-8");
    }

    public static Document nonDeferredReadXmlDocument(InputStream is, String encoding) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(is);
        inputSource.setEncoding(encoding);
        NonDeferredNamespceUnawareFactory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        DocumentBuilder builder = NonDeferredNamespceUnawareFactory.newDocumentBuilder();
        return builder.parse(inputSource);
    }

    public static Document readXmlDocument(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        return Jaxp.readXmlDocument(Lib.stringToInputStream(xmlString));
    }

    public static Document readXmlDocument(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        return Jaxp.readXmlDocument(new FileInputStream(xmlFile));
    }

    public static Document readXmlDocumentFromResource(Class<?> base, String name) throws ParserConfigurationException, SAXException, IOException {
        return Jaxp.readXmlDocument(base.getResourceAsStream(name));
    }

    public static Document readXmlDocument(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        return namespceUnawareFactory.newDocumentBuilder().parse(input);
    }

    public static Document readXmlDocumentFromResourceNamespaceAware(Class<?> base, String name) throws ParserConfigurationException, SAXException, IOException {
        return Jaxp.readXmlDocumentNamespaceAware(base.getResourceAsStream(name));
    }

    public static Document readXmlDocumentNamespaceAware(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        return Jaxp.readXmlDocumentNamespaceAware(Lib.stringToInputStream(xmlString));
    }

    public static Document readXmlDocumentNamespaceAware(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        return Jaxp.readXmlDocumentNamespaceAware(new FileInputStream(xmlFile));
    }

    public static Document readXmlDocumentNamespaceAware(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        return namespceAwareFactory.newDocumentBuilder().parse(is);
    }

    public static void setXslProperty(Document d, String xslPath) {
        ProcessingInstruction xsl = d.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + xslPath + "\"");
        d.appendChild(xsl);
    }

    public static void addComment(Document d, String comment) {
        d.appendChild(d.createComment(comment));
        d.getChildNodes().item(0);
    }

    public static void prependComment(Document d, String comment) {
        Comment commentNode = d.createComment(comment);
        Element firstNode = Jaxp.getChild(d.getDocumentElement(), "TestScript");
        d.insertBefore(commentNode, firstNode);
    }

    public static void writeXmlDocument(Document document, File file) throws IOException, TransformerException {
        Jaxp.writeXmlDocument(document, file, Jaxp.getCompactFormat());
    }

    public static void writeXmlDocument(Document document, File file, Properties format) throws TransformerException, IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        Jaxp.outputXmlDocument(document, out, format);
        out.close();
    }

    public static String xmlToString(Document document, boolean prettyOutput) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        Properties format = prettyOutput ? Jaxp.getPrettyFormat() : Jaxp.getCompactFormat();
        Jaxp.outputXmlDocument(document, stringWriter, format);
        return stringWriter.toString();
    }

    public static void outputXmlDocument(Node node, Writer output, Properties outputProperties) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperties(outputProperties);
        transformer.transform(new DOMSource(node), new StreamResult(output));
    }

    public static Properties getPrettyFormat() {
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("indent", "yes");
        format.put("encoding", "UTF-8");
        format.put("{http://xml.apache.org/xslt}indent-amount", "2");
        return format;
    }

    public static Properties getCompactFormat() {
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("indent", "no");
        format.put("encoding", "UTF-8");
        return format;
    }

    public static Document newDocumentNamespaceAware() throws ParserConfigurationException {
        DocumentBuilder builder = namespceAwareFactory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static String getDocumentXml(Document doc) throws TransformerException {
        DOMSource source = new DOMSource(doc);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, result);
        return stringWriter.getBuffer().toString();
    }

    public static final String selectNodesText(Node startingNode) {
        StringBuffer buffer = new StringBuffer();
        NodeList childNodes = startingNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 4 || node.getNodeType() == 3) {
                buffer.append(node.getNodeValue().trim());
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final Collection<Node> selectNodesViaXPath(XPath xPath, Node startingNode, String xPathExpression) throws XPathExpressionException {
        ArrayList<Node> data = new ArrayList<Node>();
        XPathExpression expression = xPath.compile(xPathExpression);
        Object result = expression.evaluate(startingNode, XPathConstants.NODESET);
        NodeList nodeList = (NodeList)result;
        int index = 0;
        while (index < nodeList.getLength()) {
            data.add(nodeList.item(index));
            ++index;
        }
        return data;
    }

    public static XPath createXPath() {
        XPathFactory factory = XPathFactory.newInstance();
        return factory.newXPath();
    }

    public static void writeNode(XMLStreamWriter writer, Node node, boolean trimTextNodeWhitespace) throws XMLStreamException {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String namespace = element.getNamespaceURI();
            String prefix = element.getPrefix();
            String name = element.getLocalName();
            if (!Strings.isValid(name)) {
                name = element.getNodeName();
            }
            if (Strings.isValid(name)) {
                String data;
                if (prefix != null && namespace != null) {
                    writer.writeStartElement(prefix, name, namespace);
                } else {
                    writer.writeStartElement(name);
                }
                if (node.hasAttributes()) {
                    NamedNodeMap nodeMap = node.getAttributes();
                    int index = 0;
                    while (index < nodeMap.getLength()) {
                        Jaxp.writeAttrNode(writer, nodeMap.item(index), true);
                        ++index;
                    }
                }
                if (node.hasChildNodes()) {
                    Jaxp.serialize(writer, element.getChildNodes(), trimTextNodeWhitespace);
                }
                if (Strings.isValid(data = Jaxp.getElementCharacterData(element, trimTextNodeWhitespace))) {
                    boolean wasCData = false;
                    NodeList childNodes = element.getChildNodes();
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        Node n = childNodes.item(i);
                        if (n.getNodeType() == 3) {
                            wasCData = true;
                            break;
                        }
                        ++i;
                    }
                    if (wasCData) {
                        writer.writeCharacters(data);
                    } else {
                        writer.writeCData(data);
                    }
                }
                writer.writeEndElement();
            }
        }
    }

    public static void serialize(XMLStreamWriter writer, NodeList nodes, boolean trimTextNodeWhitespace) throws XMLStreamException {
        int index = 0;
        while (index < nodes.getLength()) {
            Jaxp.writeNode(writer, nodes.item(index), trimTextNodeWhitespace);
            ++index;
        }
    }

    public static void writeAttrNode(XMLStreamWriter writer, Node node, boolean isEmptyValueValid) throws XMLStreamException {
        if (node.getNodeType() == 2) {
            String value;
            Attr attrNode = (Attr)node;
            String namespace = attrNode.getNamespaceURI();
            String prefix = attrNode.getPrefix();
            String name = attrNode.getLocalName();
            if (!Strings.isValid(name)) {
                name = attrNode.getNodeName();
            }
            if (Strings.isValid(name, value = attrNode.getValue()) || Strings.isValid(name) && value != null && value.isEmpty() && isEmptyValueValid) {
                if (prefix != null && namespace != null) {
                    writer.writeAttribute(prefix, namespace, name, value);
                } else if (namespace != null) {
                    writer.writeAttribute(namespace, name, value);
                } else {
                    writer.writeAttribute(name, value);
                }
            }
        }
    }

    public static void writeNode(XMLStreamWriter writer, Node node) throws XMLStreamException {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String namespace = element.getNamespaceURI();
            String prefix = element.getPrefix();
            String name = element.getNodeName();
            if (Strings.isValid(name)) {
                String text;
                if (prefix != null && namespace != null) {
                    writer.writeStartElement(prefix, name, namespace);
                } else if (namespace != null) {
                    writer.writeStartElement(namespace, name);
                } else {
                    writer.writeStartElement(name);
                }
                if (node.hasAttributes()) {
                    NamedNodeMap nodeMap = node.getAttributes();
                    int index = 0;
                    while (index < nodeMap.getLength()) {
                        Jaxp.writeAttrNode(writer, nodeMap.item(index), false);
                        ++index;
                    }
                }
                if (node.hasChildNodes()) {
                    Jaxp.serialize(writer, element.getChildNodes());
                }
                if (Strings.isValid(text = Jaxp.getElementCharacterData(element, true))) {
                    writer.writeCharacters(text);
                }
                writer.writeEndElement();
            }
        }
    }

    public static void serialize(XMLStreamWriter writer, NodeList nodes) throws XMLStreamException {
        int index = 0;
        while (index < nodes.getLength()) {
            Jaxp.writeNode(writer, nodes.item(index));
            ++index;
        }
    }
}

