/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlTransformServer {
    private static int MAX_PACKET_SIZE = 65536;
    private static int FINISH_PROCESSING_FLAG = -1;
    private static int TIMEOUT = 180000;
    private InputStream inputFromNetwork;
    private OutputStream outputToNetwork;
    private Socket clientSocket;
    private ServerSocket server = null;
    private int portNumber = 0;
    private final String userHome = System.getProperty("user.home");

    private void initializeServer(int portNumber) throws Exception {
        this.portNumber = portNumber;
        try {
            this.server = new ServerSocket(portNumber);
            this.clientSocket = this.server.accept();
            this.inputFromNetwork = new BufferedInputStream(this.clientSocket.getInputStream());
            this.outputToNetwork = new BufferedOutputStream(this.clientSocket.getOutputStream());
        }
        catch (Exception ex) {
            throw new Exception("Unable to launch Server and get Connection. ", ex);
        }
    }

    public void process() throws Exception {
        this.performRead("xml", ".xml");
        this.performRead("xslt", ".xsl");
        this.performWrite();
    }

    private void performRead(String prefix, String extension) throws Exception {
        File file = new File(String.valueOf(this.userHome) + File.separator + prefix + this.portNumber + extension);
        file.createNewFile();
        try (FileOutputStream fos = new FileOutputStream(file);){
            try {
                XmlTransformServer.receiveStream(this.clientSocket, this.inputFromNetwork, new PrintStream(fos));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                fos.close();
            }
        }
    }

    private void performWrite() throws Exception {
        File file;
        block10: {
            file = new File(String.valueOf(this.userHome) + File.separator + "html" + this.portNumber + ".html");
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            File fisXml = new File(String.valueOf(this.userHome) + File.separator + "xml" + this.portNumber + ".xml");
            File fisXslt = new File(String.valueOf(this.userHome) + File.separator + "xslt" + this.portNumber + ".xsl");
            ErrorListener listener = null;
            try {
                try {
                    System.gc();
                    Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(fisXslt));
                    listener = transformer.getErrorListener();
                    transformer.transform(new StreamSource(fisXml), new StreamResult(fos));
                }
                catch (Exception ex) {
                    PrintWriter pw = new PrintWriter(fos);
                    pw.write("Error during Transform. " + (listener != null ? listener.toString() : ""));
                    ex.printStackTrace(pw);
                    fos.close();
                    fisXml.delete();
                    fisXslt.delete();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                fos.close();
                fisXml.delete();
                fisXslt.delete();
                throw throwable;
            }
            fos.close();
            fisXml.delete();
            fisXslt.delete();
        }
        System.gc();
        FileInputStream fis = new FileInputStream(file);
        try {
            try {
                XmlTransformServer.sendStream(this.clientSocket, fis, this.outputToNetwork);
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ((InputStream)fis).close();
                file.delete();
            }
        }
        finally {
            ((InputStream)fis).close();
            file.delete();
        }
    }

    private void clearResources() throws Exception {
        if (this.outputToNetwork != null) {
            this.outputToNetwork.close();
        }
        if (this.inputFromNetwork != null) {
            this.inputFromNetwork.close();
        }
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
        if (this.server != null) {
            this.server.close();
        }
    }

    public static void sendStream(Socket socket, InputStream in, OutputStream out) throws Exception {
        socket.setSoTimeout(TIMEOUT);
        try {
            int numberOfBytes = 0;
            byte[] buffer = new byte[MAX_PACKET_SIZE];
            while ((numberOfBytes = in.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, numberOfBytes);
            }
            out.write(FINISH_PROCESSING_FLAG);
            out.flush();
        }
        catch (Exception ex) {
            throw new Exception("Error during send.", ex);
        }
    }

    public static void receiveStream(Socket socket, InputStream in, OutputStream out) throws Exception {
        socket.setSoTimeout(TIMEOUT);
        try {
            int numberOfBytes = 0;
            byte[] buffer = new byte[MAX_PACKET_SIZE];
            while ((numberOfBytes = in.read(buffer, 0, buffer.length)) != -1) {
                if (buffer[numberOfBytes - 1] == -1) {
                    out.write(buffer, 0, numberOfBytes - 1);
                    break;
                }
                out.write(buffer, 0, numberOfBytes);
            }
            out.flush();
        }
        catch (Exception ex) {
            throw new Exception("Error during receive.", ex);
        }
    }

    public static void receiveStream(Socket socket, InputStream in, Writer out) throws Exception {
        socket.setSoTimeout(TIMEOUT);
        try {
            int numberOfBytes = 0;
            byte[] buffer = new byte[MAX_PACKET_SIZE];
            while ((numberOfBytes = in.read(buffer, 0, buffer.length)) != -1) {
                if (buffer[numberOfBytes - 1] == -1) {
                    out.write(new String(buffer, 0, numberOfBytes - 1));
                    break;
                }
                out.write(new String(buffer, 0, numberOfBytes));
            }
            out.flush();
        }
        catch (Exception ex) {
            throw new Exception("Error during receive.", ex);
        }
    }

    public static void main(String[] args) {
        XmlTransformServer xmlTransformServer = new XmlTransformServer();
        try {
            try {
                int port = Integer.parseInt(args[0]);
                xmlTransformServer.initializeServer(port);
                xmlTransformServer.process();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    xmlTransformServer.clearResources();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                xmlTransformServer.clearResources();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

