/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.AtsWorldEditorRenderer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.util.RendererOption;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;

public class WorkflowPortingBlam
extends AbstractBlam {
    private static final String SOURCE_WORKFLOWS = "Source Workflows (drop here)";
    private static final String ACTIONABLE_ITEM = "Destination actionable item(s)";
    private List<TeamWorkFlowArtifact> sourceWorkflows;

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) {
        this.sourceWorkflows = org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)variableMap.getArtifacts(SOURCE_WORKFLOWS));
        Conditions.checkNotNullOrEmpty(this.sourceWorkflows, (String)SOURCE_WORKFLOWS);
        List<IAtsActionableItem> actionableItems = this.getActionableItems((IAtsActionableItem)variableMap.getValue(ACTIONABLE_ITEM));
        Conditions.checkNotNullOrEmpty(actionableItems, (String)ACTIONABLE_ITEM);
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Create Porting Workflow(s)");
        List<Artifact> destinationWorkflows = this.createDestinationWorkflows(changes, actionableItems);
        changes.execute();
        AtsWorldEditorRenderer renderer = new AtsWorldEditorRenderer(new HashMap<RendererOption, Object>());
        renderer.open(destinationWorkflows, PresentationType.SPECIALIZED_EDIT);
    }

    private List<Artifact> createDestinationWorkflows(IAtsChangeSet changes, List<IAtsActionableItem> actionableItems) {
        IAtsTeamDefinition teamDefinition = actionableItems.get(0).getTeamDefinition();
        ArrayList<Artifact> destinationWorkflows = new ArrayList<Artifact>();
        AtsUser createdBy = AtsApiService.get().getUserService().getCurrentUser();
        Date createdDate = new Date();
        for (TeamWorkFlowArtifact sourceWorkflow : this.sourceWorkflows) {
            IAtsTeamWorkflow destinationWorkflow;
            if (sourceWorkflow.getRelatedArtifacts(AtsRelationTypes.Port_To).isEmpty()) {
                List assignees = sourceWorkflow.getStateMgr().getAssignees();
                destinationWorkflow = AtsApiService.get().getActionService().createTeamWorkflow(sourceWorkflow.getParentAction(), teamDefinition, actionableItems, assignees, changes, createdDate, createdBy, null, new CreateTeamOption[]{CreateTeamOption.Duplicate_If_Exists});
                changes.setName((IAtsObject)destinationWorkflow, sourceWorkflow.getName());
                changes.relate((Object)sourceWorkflow, AtsRelationTypes.Port_To, (Object)destinationWorkflow);
            } else {
                destinationWorkflow = AtsApiService.get().getWorkItemService().getTeamWf(AtsApiService.get().getRelationResolver().getRelatedOrNull((ArtifactId)sourceWorkflow, AtsRelationTypes.Port_To));
                this.log(new String[]{"Reusing destination workflow " + destinationWorkflow});
            }
            destinationWorkflows.add(AtsApiService.get().getQueryServiceIde().getArtifact(destinationWorkflow));
        }
        return destinationWorkflows;
    }

    private List<IAtsActionableItem> getActionableItems(IAtsActionableItem actionableItem) {
        List<IAtsActionableItem> actionableItems = actionableItem == null ? new ArrayList<IAtsActionableItem>(AtsApiService.get().getActionableItemService().getActionableItems((IAtsWorkItem)this.sourceWorkflows.get(0))) : Collections.singletonList(actionableItem);
        return actionableItems;
    }

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XListDropViewer\" displayName=\"Source Workflows (drop here)\" /><XWidget xwidgetType=\"XActionableItemCombo\" displayName=\"Destination actionable item(s)\" /></xWidgets>";
    }

    public String getDescriptionUsage() {
        return "Create porting workflows related by port relation for selected actionable items (or same as source workflow)";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AtsNavigateViewItems.ATS_ADMIN, XNavItemCat.OSEE_ADMIN);
    }
}

