/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.HashSet;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public abstract class AbstractBranchColumn
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public AbstractBranchColumn(String idPostfix, String name) {
        super("ats.column" + idPostfix, name, 40, XViewerAlign.Center, false, SortDataType.String, false, null);
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        String result;
        block10: {
            result = "";
            try {
                if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.AbstractWorkflowArtifact)) {
                    TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)((AbstractWorkflowArtifact)((Object)element)).getParentTeamWorkflow();
                    if (teamArt == null) break block10;
                    try {
                        BranchToken workingBranch = null;
                        if (AtsApiService.get().getBranchService().isWorkingBranchInWork((IAtsTeamWorkflow)teamArt)) {
                            workingBranch = AtsApiService.get().getBranchService().getWorkingBranch((IAtsTeamWorkflow)teamArt);
                        }
                        if (workingBranch == null) {
                            workingBranch = AtsApiService.get().getBranchService().getCommittedWorkingBranch((IAtsTeamWorkflow)teamArt);
                        }
                        if (workingBranch != null && workingBranch.isValid()) {
                            result = this.getColumnText((BranchId)workingBranch);
                        }
                        break block10;
                    }
                    catch (Exception ex) {
                        result = "Exception: " + ex.getLocalizedMessage();
                    }
                    break block10;
                }
                if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                    HashSet<String> strs = new HashSet<String>();
                    for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(element)) {
                        String str = this.getColumnText(team, column, columnIndex);
                        if (!Strings.isValid((String)str)) continue;
                        strs.add(str);
                    }
                    result = Collections.toString((String)", ", strs);
                }
            }
            catch (OseeCoreException ex) {
                LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
        }
        return result;
    }

    abstract String getColumnText(BranchId var1);
}

