/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingValueProvider;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.swt.Displays;

public abstract class BackgroundLoadingColumn
extends XViewerAtsColumn
implements IXViewerPreComputedColumn,
BackgroundLoadingValueProvider {
    public AtomicBoolean loading = new AtomicBoolean(false);
    public AtomicBoolean loaded = new AtomicBoolean(false);
    protected Map<Long, String> idToValueMap = new HashMap<Long, String>();

    public BackgroundLoadingColumn(String id, String name, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(id, name, width, align, show, sortDataType, multiColumnEditable, description);
    }

    private void startLoadingThread(Collection<?> objects) {
        BackgroundLoadingColumn.startLoadingThread(this.getName(), objects, this.loading, this.loaded, this.idToValueMap, (WorldXViewer)this.getXViewer(), this);
    }

    public static void startLoadingThread(String name, final Collection<?> objects, final AtomicBoolean loading, final AtomicBoolean loaded, final Map<Long, String> idToValueMap, final WorldXViewer xViewer, final BackgroundLoadingValueProvider valueProvider) {
        Thread loadingThread = new Thread("Loading " + name){

            @Override
            public void run() {
                valueProvider.getValues(objects, idToValueMap);
                for (Object element : objects) {
                    Long key = valueProvider.getKey(element);
                    try {
                        IAtsWorkItem workItem;
                        String value;
                        if (!(element instanceof IAtsWorkItem) || (value = valueProvider.getValue(workItem = (IAtsWorkItem)element, idToValueMap)) == null) continue;
                        idToValueMap.put(key, value);
                    }
                    catch (OseeCoreException ex) {
                        String cellExceptionString = LogUtil.getCellExceptionString((Exception)((Object)ex));
                        idToValueMap.put(key, cellExceptionString);
                    }
                }
                loading.set(false);
                loaded.set(true);
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        xViewer.refreshColumnsWithPreCompute();
                    }
                });
            }
        };
        loadingThread.start();
    }

    @Override
    public Long getKey(Object obj) {
        if (obj instanceof IAtsTeamWorkflow) {
            return ((IAtsTeamWorkflow)obj).getId();
        }
        return null;
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        if (!this.loaded.get() && !this.loading.getAndSet(true)) {
            this.startLoadingThread(objects);
        }
    }

    public String getText(Object obj, Long key, String cachedValue) {
        return BackgroundLoadingColumn.getText(obj, this.loading, this.loaded, this.idToValueMap);
    }

    public static String getText(Object obj, AtomicBoolean loading, AtomicBoolean loaded, Map<Long, String> idToValueMap) {
        block5: {
            block6: {
                if (!(obj instanceof IAtsWorkItem)) break block5;
                if (!loading.get()) break block6;
                return "loading...";
            }
            try {
                if (loaded.get()) {
                    IAtsWorkItem workItem = (IAtsWorkItem)obj;
                    String value = idToValueMap.get(workItem.getId());
                    if (value != null) {
                        return value;
                    }
                    return "unknown";
                }
            }
            catch (OseeCoreException ex) {
                LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
        }
        return "";
    }
}

