/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class PercentCompleteStateTasksColumn
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static PercentCompleteStateTasksColumn instance = new PercentCompleteStateTasksColumn();

    public static PercentCompleteStateTasksColumn getInstance() {
        return instance;
    }

    private PercentCompleteStateTasksColumn() {
        super("ats.column.stateTaskPercentComplete", "State Task Percent Complete", 40, XViewerAlign.Center, false, SortDataType.Percent, false, "Percent Complete for the tasks related to the current state.\n\nCalculation: total percent of all tasks related to state / number of tasks related to state");
    }

    public PercentCompleteStateTasksColumn copy() {
        PercentCompleteStateTasksColumn newXCol = new PercentCompleteStateTasksColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof Artifact) {
                return String.valueOf(PercentCompleteStateTasksColumn.getPercentCompleteFromStateTasks(AtsApiService.get().getQueryServiceIde().getArtifact(element)));
            }
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }

    public static int getPercentCompleteFromStateTasks(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            double percent = 0.0;
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)artifact)) {
                if (team.isCancelled()) continue;
                percent += (double)PercentCompleteStateTasksColumn.getPercentCompleteFromStateTasks(AtsApiService.get().getQueryServiceIde().getArtifact(team));
            }
            if (percent == 0.0) {
                return 0;
            }
            Double rollPercent = percent / (double)AtsApiService.get().getWorkItemService().getTeams((Object)artifact).size();
            return rollPercent.intValue();
        }
        if (artifact instanceof TeamWorkFlowArtifact) {
            return PercentCompleteStateTasksColumn.getPercentCompleteFromStateTasks(artifact, ((TeamWorkFlowArtifact)artifact).getStateMgr().getCurrentState());
        }
        return 0;
    }

    public static int getPercentCompleteFromStateTasks(Artifact artifact, IStateToken relatedToState) {
        if (!(artifact instanceof TeamWorkFlowArtifact)) {
            return 0;
        }
        return AtsApiService.get().getEarnedValueService().getPercentCompleteFromTasks((IAtsWorkItem)((TeamWorkFlowArtifact)artifact), relatedToState);
    }
}

