/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingColumn;
import org.eclipse.osee.ats.ide.config.AtsBulkLoad;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class SiblingAtsIdColumn
extends BackgroundLoadingColumn {
    public static SiblingAtsIdColumn instance = new SiblingAtsIdColumn();
    private final List<String> ids = new ArrayList<String>();

    public static SiblingAtsIdColumn getInstance() {
        return instance;
    }

    private SiblingAtsIdColumn() {
        super("ats.column.sibling.ats.id", "Sibling ATS Ids", 100, XViewerAlign.Left, false, SortDataType.String, false, "");
    }

    public SiblingAtsIdColumn copy() {
        SiblingAtsIdColumn newXCol = new SiblingAtsIdColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public String getValue(IAtsWorkItem workItem, Map<Long, String> idToValueMap) {
        this.ids.clear();
        if (workItem instanceof IAtsTeamWorkflow) {
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
            for (IAtsTeamWorkflow sibTeamWf : AtsApiService.get().getWorkItemService().getSiblings(teamWf)) {
                this.ids.add(sibTeamWf.getAtsId());
            }
        }
        return Collections.toString((String)", ", this.ids);
    }

    @Override
    public void getValues(Collection<?> objects, Map<Long, String> idToValueMap) {
        List arts = Collections.castAll(objects);
        AtsBulkLoad.bulkLoadSiblings(arts);
    }
}

