/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.history.column;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.WorkState;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class EventColumn
extends XViewerValueColumn {
    private static EventColumn instance = new EventColumn();

    public static EventColumn getInstance() {
        return instance;
    }

    public EventColumn() {
        super("ats.history.Event", "Event", 290, XViewerAlign.Left, true, SortDataType.String, false, "");
    }

    public EventColumn copy() {
        EventColumn newXCol = new EventColumn();
        this.copy((XViewerColumn)this, (XViewerColumn)newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        block6: {
            Change change;
            block7: {
                if (element instanceof String) {
                    return (String)element;
                }
                if (!(element instanceof Change)) break block6;
                change = (Change)element;
                if (change.getItemTypeName().equals(AtsAttributeTypes.CurrentState.getName())) {
                    return this.processCurrentStateChange(change);
                }
                if (!change.getItemTypeName().equals(AtsAttributeTypes.CurrentStateType.getName())) break block6;
                if (!change.getIsValue().equals(StateType.Completed.name())) break block7;
                return "Completed";
            }
            try {
                if (change.getIsValue().equals(StateType.Cancelled.name())) {
                    return "Cancelled";
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return "";
    }

    public Image getColumnImage(Object element, XViewerColumn col, int columnIndex) {
        if (col.getName().equals("Event")) {
            String text = this.getColumnText(element, (XViewerColumn)EventColumn.getInstance(), columnIndex);
            if (text.startsWith("Assigned") || text.equals("UnAssigned")) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.USERS);
            }
            if (text.startsWith("Statused")) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.GREEN_PLUS);
            }
            if (text.startsWith("Transition")) {
                return ImageManager.getImage((OseeImage)AtsImage.TRANSITION);
            }
            if (text.startsWith("Created")) {
                return ImageManager.getImage((OseeImage)AtsImage.ACTION);
            }
            if (text.startsWith("Completed")) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.DOT_GREEN);
            }
            if (text.startsWith("Cancelled")) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.X_RED);
            }
        }
        return null;
    }

    public String processCurrentStateChange(Change change) {
        try {
            WorkState was = AtsApiService.get().getWorkStateFactory().fromStoreStr(change.getWasValue());
            WorkState is = AtsApiService.get().getWorkStateFactory().fromStoreStr(change.getIsValue());
            if (change.getWasValue().equals("")) {
                return "Created in [" + is.getName() + "] state";
            }
            if (!was.getName().equals(is.getName())) {
                return "Transition from [" + was.getName() + "] to [" + is.getName() + "]";
            }
            if (was.getName().equals(is.getName()) && (was.getPercentComplete() != is.getPercentComplete() || !EventColumn.getHoursSpentStr(was).equals(EventColumn.getHoursSpentStr(is)))) {
                return "Statused [" + is.getName() + "] to: " + is.getPercentComplete() + "% and " + this.getHoursSpent(is) + " hrs";
            }
            List wasAssignees = was.getAssignees();
            List isAssignees = is.getAssignees();
            HashSet<AtsUser> assigned = new HashSet<AtsUser>();
            HashSet<AtsUser> unAssigned = new HashSet<AtsUser>();
            for (AtsUser isAssignee : isAssignees) {
                if (wasAssignees.contains(isAssignee)) continue;
                assigned.add(isAssignee);
            }
            for (AtsUser wasAssignee : wasAssignees) {
                if (isAssignees.contains(wasAssignee)) continue;
                unAssigned.add(wasAssignee);
            }
            if (unAssigned.size() > 0) {
                return "UnAssigned [" + is.getName() + "] removed " + AtsObjects.toString((String)"; ", unAssigned);
            }
            if (assigned.size() > 0) {
                return "Assigned [" + is.getName() + "] to " + AtsObjects.toString((String)"; ", assigned);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return "";
    }

    private String getHoursSpent(WorkState state) {
        return Strings.isValid((String)EventColumn.getHoursSpentStr(state)) ? EventColumn.getHoursSpentStr(state) : "0";
    }

    public static String getHoursSpentStr(WorkState state) {
        return AtsUtil.doubleToI18nString((double)state.getHoursSpent(), (boolean)true);
    }
}

