/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.reload.WfeReloadTab;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.review.ReviewManager;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class WfeReloadAction
extends AbstractAtsAction {
    private final AbstractWorkflowArtifact workItem;
    private final WorkflowEditor editor;

    public WfeReloadAction(AbstractWorkflowArtifact workItem, WorkflowEditor editor) {
        this.editor = editor;
        String title = "Reload \"" + workItem.getArtifactTypeName() + "\"";
        this.setText(title);
        this.setToolTipText(this.getText());
        this.workItem = workItem;
    }

    @Override
    public void runWithException() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (WfeReloadAction.this.editor != null) {
                    if (WfeReloadAction.this.editor.isDirty()) {
                        MessageDialog dialog = new MessageDialog(Displays.getActiveShell(), "Reload confirmation", null, "The current editor has unsaved changes.  Do you want to save changes and reload?", 0, new String[]{"Save and Reload", "Cancel"}, 0);
                        int result = dialog.open();
                        if (result == 1) {
                            return;
                        }
                        WfeReloadAction.this.editor.doSave(null, new WorkflowEditor.WfeSaveListener(){

                            @Override
                            public void saved(IAtsWorkItem workItem, IAtsChangeSet changes) {
                                try {
                                    Thread reloadThread = this.getReloadThread();
                                    reloadThread.start();
                                }
                                catch (Exception ex) {
                                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                                }
                            }
                        });
                    } else {
                        try {
                            Thread reloadThread = this.getReloadThread();
                            reloadThread.start();
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        }
                    }
                }
            }

            private Thread getReloadThread() {
                Thread reloadThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HashSet<AbstractWorkflowArtifact> relatedArts = new HashSet<AbstractWorkflowArtifact>();
                        relatedArts.add((this).WfeReloadAction.this.workItem);
                        if ((this).WfeReloadAction.this.workItem.isTeamWorkflow()) {
                            relatedArts.addAll(ReviewManager.getReviews((TeamWorkFlowArtifact)(this).WfeReloadAction.this.workItem));
                        }
                        if ((this).WfeReloadAction.this.workItem instanceof TeamWorkFlowArtifact) {
                            Collection tasks = AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)((TeamWorkFlowArtifact)(this).WfeReloadAction.this.workItem));
                            relatedArts.addAll(Collections.castAll((Collection)tasks));
                        }
                        ArtifactQuery.reloadArtifacts(relatedArts);
                        WfeReloadTab reload = new WfeReloadTab((this).WfeReloadAction.this.editor);
                        reload.reloadEditor("Reload WFE Editor");
                    }
                });
                return reloadThread;
            }
        });
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)PluginUiImage.REFRESH);
    }
}

