/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.ats.ide.search.LoadSearchItemAction;
import org.eclipse.osee.ats.ide.search.QuickSearchDataComparator;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.util.StringLabelProvider;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public final class LoadSearchAction
extends Action
implements IMenuCreator {
    private final AtsSearchWorkflowSearchItem searchItem;
    private Menu fMenu;

    public LoadSearchAction(AtsSearchWorkflowSearchItem searchItem) {
        this.searchItem = searchItem;
        this.setMenuCreator(this);
    }

    public String getText() {
        return "Load Saved Search";
    }

    public void run() {
        ArrayList searchDatas = AtsApiService.get().getQueryService().getSavedSearches(this.searchItem.getNamespace());
        Collections.sort(searchDatas, new QuickSearchDataComparator());
        FilteredTreeDialog dialog = new FilteredTreeDialog("Load Saved Search", "Select Search", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new StringLabelProvider());
        dialog.setInput((Object)searchDatas);
        if (dialog.open() == 0) {
            AtsSearchData selected = (AtsSearchData)dialog.getSelectedFirst();
            this.searchItem.loadWidgets(selected);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.LOAD);
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        try {
            ArrayList searchDatas = AtsApiService.get().getQueryService().getSavedSearches(this.searchItem.getNamespace());
            Collections.sort(searchDatas, new QuickSearchDataComparator());
            for (AtsSearchData data : searchDatas) {
                this.addActionToMenu(this.fMenu, new LoadSearchItemAction(data, this.searchItem));
            }
            if (searchDatas.isEmpty()) {
                this.setToolTipText("No Searches Saved");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Unable to load saved search data", (Throwable)ex);
        }
        return this.fMenu;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    void clear() {
        this.dispose();
    }
}

