/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelActionableItemSelection;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactId;

public class ActionableItemSearchWidget {
    private final WorldEditorParameterSearchItem searchItem;

    public ActionableItemSearchWidget(WorldEditorParameterSearchItem searchItem) {
        this.searchItem = searchItem;
    }

    public void addWidget(int beginComposite) {
        this.searchItem.addWidgetXml(String.format("<XWidget displayName=\"Actionable Item(s)\" xwidgetType=\"XHyperlabelActionableItemSelection\" horizontalLabel=\"true\" %s />", this.searchItem.getBeginComposite(beginComposite)));
    }

    public Collection<Long> getIds() {
        LinkedList<Long> ids = new LinkedList<Long>();
        if (this.get() != null) {
            for (IAtsActionableItem ai : this.get()) {
                ids.add(ai.getId());
            }
        }
        return ids;
    }

    public Collection<IAtsActionableItem> get() {
        XHyperlabelActionableItemSelection widget = this.getWidget();
        if (widget != null) {
            return widget.getSelectedActionableItems();
        }
        return null;
    }

    public XHyperlabelActionableItemSelection getWidget() {
        return (XHyperlabelActionableItemSelection)this.searchItem.getxWidgets().get("Actionable Item(s)");
    }

    public void set(Collection<IAtsActionableItem> ais) {
        if (this.getWidget() != null) {
            this.getWidget().setSelectedAIs(ais);
        }
    }

    public void set(AtsSearchData data) {
        LinkedList<IAtsActionableItem> ais = new LinkedList<IAtsActionableItem>();
        for (Long id : data.getAiIds()) {
            ActionableItem ai = AtsApiService.get().getActionableItemService().getActionableItemById(ArtifactId.valueOf((Long)id));
            if (ai == null) continue;
            ais.add((IAtsActionableItem)ai);
        }
        this.set(ais);
    }
}

