/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.widget.AbstractXComboViewerSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.InsertionActivitySearchWidget;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class WorkPackageSearchWidget
extends AbstractXComboViewerSearchWidget<IAtsWorkPackage> {
    public static final String WORK_PACKAGE = "Work Package";
    private InsertionActivitySearchWidget insertionActivityWidget;

    public WorkPackageSearchWidget(WorldEditorParameterSearchItem searchItem) {
        super(WORK_PACKAGE, searchItem);
    }

    @Override
    public void set(AtsSearchData data) {
        if (this.getWidget() != null) {
            this.setup((XWidget)this.getWidget());
            Long workPackageId = data.getWorkPackageId();
            if (workPackageId != null && workPackageId > 0L) {
                IAtsWorkPackage workPackage = AtsApiService.get().getProgramService().getWorkPackage(workPackageId);
                XComboViewer combo = this.getWidget();
                combo.setSelected(Arrays.asList(workPackage));
            }
        }
    }

    @Override
    public Collection<IAtsWorkPackage> getInput() {
        Object selected;
        if (this.insertionActivityWidget != null && this.insertionActivityWidget.get() != null && (selected = this.insertionActivityWidget.getWidget().getSelected()) != null && selected instanceof IAtsInsertionActivity) {
            return Collections.castAll((Collection)AtsApiService.get().getEarnedValueService().getWorkPackages((IAtsInsertionActivity)this.insertionActivityWidget.get()));
        }
        return java.util.Collections.emptyList();
    }

    public void setInsertionActivityWidget(InsertionActivitySearchWidget insertionActivityWidget) {
        this.insertionActivityWidget = insertionActivityWidget;
        insertionActivityWidget.getWidget().getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkPackageSearchWidget.this.setup((XWidget)WorkPackageSearchWidget.this.getWidget());
            }
        });
    }

    @Override
    public String getInitialText() {
        if (this.insertionActivityWidget == null || this.insertionActivityWidget.get() == null) {
            return "--select activity--";
        }
        return "";
    }
}

