/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.util.StringLabelProvider;
import org.eclipse.osee.framework.ui.skynet.util.StringNameComparator;
import org.eclipse.osee.framework.ui.skynet.widgets.AttributeWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.swt.widgets.Shell;

public class XHyperlinkWorkDefDam
extends XHyperlinkLabelValueSelection
implements AttributeWidget {
    private AttributeTypeToken attributeTypeToken;
    private final AtsApi atsApi = AtsApiService.get();
    private String value = "Not Set";
    private Artifact artifact;

    public XHyperlinkWorkDefDam() {
        this("Workflow Definition");
    }

    public XHyperlinkWorkDefDam(String label) {
        super(label);
    }

    public String getCurrentValue() {
        if (this.artifact == null) {
            this.value = "Not Set";
        } else {
            ArtifactId workDefId = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, this.attributeTypeToken, (Object)ArtifactId.SENTINEL);
            if (workDefId.isInvalid()) {
                this.value = "Not Set";
            } else {
                IAtsWorkDefinition workDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)workDefId);
                this.value = workDefinition.getName();
            }
        }
        return this.value;
    }

    public Artifact getArtifact() {
        if (this.artifact == null) {
            return null;
        }
        return this.artifact;
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setAttributeType(Artifact artifact, AttributeTypeToken attributeTypeToken) {
        this.attributeTypeToken = attributeTypeToken;
        this.artifact = artifact;
    }

    public boolean handleSelection() {
        if (!this.atsApi.getUserService().isAtsAdmin()) {
            AWorkbench.popup((String)"Only ATS Admins can set this value and it should normally not be changed");
            return false;
        }
        try {
            if (MessageDialog.openConfirm((Shell)AWorkbench.getActiveShell(), (String)"Change Work Definition", (String)"This is an ATS Admin function only and NOT an normal function due to incompatibilty between Work Definitions\n\nAre you sure?")) {
                FilteredTreeDialog dialog = new FilteredTreeDialog("Select Work Definition", "Select Work Definition", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new StringLabelProvider(), (ViewerComparator)new StringNameComparator());
                dialog.setInput((Object)this.atsApi.getWorkDefinitionService().getAllWorkDefinitions());
                if (dialog.open() == 0) {
                    IAtsWorkDefinition workDef = (IAtsWorkDefinition)dialog.getSelectedFirst();
                    IAtsChangeSet changes = this.atsApi.createChangeSet(this.getLabel());
                    changes.setSoleAttributeValue((ArtifactId)this.artifact, this.attributeTypeToken, (Object)ArtifactId.valueOf((Long)workDef.getId()));
                    changes.execute();
                    this.refresh();
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeTypeToken;
    }
}

