/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.logging.OseeLog;

public class AITreeContentProvider
implements ITreeContentProvider {
    private final Active active;
    private boolean showChildren = true;

    public AITreeContentProvider(Active active) {
        this.active = active;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Collection) {
            return ((Collection)parentElement).toArray();
        }
        if (parentElement instanceof IAtsActionableItem && this.showChildren) {
            try {
                IAtsActionableItem ai = (IAtsActionableItem)parentElement;
                List aias = AtsApiService.get().getActionableItemService().getActive((Collection)AtsApiService.get().getActionableItemService().getChildren(ai, false), this.active);
                return aias.toArray();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IAtsActionableItem) {
            return ((IAtsActionableItem)element).getParentActionableItem();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setShowChildren(boolean showChildren) {
        this.showChildren = showChildren;
    }
}

