/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.AtsWorkItemServiceImpl;
import org.eclipse.osee.ats.ide.workflow.IAtsWorkItemServiceIde;
import org.eclipse.osee.ats.ide.workflow.hooks.IAtsWorkItemHookIde;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class AtsWorkItemServiceClientImpl
extends AtsWorkItemServiceImpl
implements IAtsWorkItemServiceIde {
    public AtsWorkItemServiceClientImpl(AtsApi atsApi, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        super(atsApi, teamWorkflowProvidersLazy);
    }

    @Override
    public Set<IAtsWorkItemHookIde> getWorkItemHooksIde() {
        HashSet<IAtsWorkItemHookIde> hooks = new HashSet<IAtsWorkItemHookIde>();
        for (IAtsWorkItemHook hook : workflowHooks) {
            if (!(hook instanceof IAtsWorkItemHookIde)) continue;
            hooks.add((IAtsWorkItemHookIde)hook);
        }
        return hooks;
    }

    public TransitionResults transition(TransitionData transData) {
        this.populateTransitionData(transData);
        TransitionResults results = this.atsApi.getServerEndpoints().getActionEndpoint().transition(transData);
        results.setAtsApi(this.atsApi);
        if (results.isErrors()) {
            return results;
        }
        results = this.postEventAndReturn(transData, results);
        return results;
    }

    private void populateTransitionData(TransitionData transData) {
        for (IAtsWorkItem workItem : transData.getWorkItems()) {
            transData.getWorkItemIds().add(workItem.getStoreObject());
        }
        if (transData.getTransitionUser() == null) {
            transData.setTransitionUser(this.atsApi.getUserService().getCurrentUser());
        }
    }

    public TransitionResults transition(ITransitionHelper helper) {
        TransitionResults results;
        Collection toAssignees;
        helper.setAtsApi(this.atsApi);
        TransitionData transData = helper.getTransData();
        if (helper.getWorkItems().size() == 1 && (toAssignees = helper.getToAssignees((IAtsWorkItem)helper.getWorkItems().iterator().next())) != null) {
            transData.setToAssignees((Collection)Collections.castAll((Collection)toAssignees));
        }
        if (helper.getTransitionUser() != null) {
            transData.setTransitionUser(helper.getTransitionUser());
        }
        transData.setToStateName(helper.getToStateName());
        transData.setName(helper.getName());
        transData.setWorkItems(helper.getWorkItems());
        IAtsStateDefinition toStateDef = this.atsApi.getWorkDefinitionService().getStateDefinitionByName((IAtsWorkItem)helper.getWorkItems().iterator().next(), helper.getToStateName());
        if (toStateDef.getStateType() == StateType.Cancelled) {
            transData.setCancellationReason("temp reason");
        }
        if ((results = this.transitionValidate(transData)).isErrors()) {
            return results;
        }
        helper.getCancellationReason(transData);
        if (transData.isDialogCancelled()) {
            results.setCancelled(true);
            return results;
        }
        results = this.transition(transData);
        results.setAtsApi(this.atsApi);
        return results;
    }

    public TransitionResults transitionValidate(TransitionData transData) {
        this.populateTransitionData(transData);
        TransitionResults results = this.atsApi.getServerEndpoints().getActionEndpoint().transitionValidate(transData);
        results.setAtsApi(this.atsApi);
        return results;
    }

    private TransitionResults postEventAndReturn(TransitionData transData, TransitionResults results) {
        Conditions.assertNotNullOrEmpty((Collection)results.getWorkItemIds(), (String)"workItemIds", (Object[])new Object[0]);
        this.atsApi.getStoreService().reload(transData.getWorkItems());
        if (results.isSuccess()) {
            this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_MODIFIED, transData.getWorkItems(), results.getTransaction());
            this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_TRANSITIONED, transData.getWorkItems(), results.getTransaction());
        } else {
            this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_TRANSITION_FAILED, transData.getWorkItems(), results.getTransaction());
        }
        return results;
    }
}

