/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.cr.taskest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstDefinition;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.cr.taskest.XTaskEstActionBar;
import org.eclipse.osee.ats.ide.workflow.cr.taskest.XTaskEstContentProvider;
import org.eclipse.osee.ats.ide.workflow.cr.taskest.XTaskEstLabelProvider;
import org.eclipse.osee.ats.ide.workflow.cr.taskest.XTaskEstXViewerFactory;
import org.eclipse.osee.ats.ide.workflow.task.TaskXViewer;
import org.eclipse.osee.ats.ide.workflow.task.mini.XMiniTaskWidget;
import org.eclipse.osee.ats.ide.world.WorldContentProvider;
import org.eclipse.osee.ats.ide.world.WorldLabelProvider;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public abstract class XTaskEstWidget
extends XMiniTaskWidget {
    public static final String WIDGET_ID = XTaskEstWidget.class.getSimpleName();
    private static final String INFO_STRING = "Select to create estimating tasks.  Complete all estimates/tasks.  Double-Click to open/edit task/fields.";
    private AttributeTypeToken pointsAttrType;
    private final List<Object> input = new ArrayList<Object>();
    public static String NAME = "Estimate Manager";

    public XTaskEstWidget() {
        super(NAME, (IXViewerFactory)new XTaskEstXViewerFactory());
    }

    @Override
    public ToolBar createActionBar(Composite tableComp) {
        XTaskEstActionBar actionBar = new XTaskEstActionBar(this);
        ToolBar toolBar = actionBar.createTaskActionBar(tableComp);
        return toolBar;
    }

    @Override
    protected abstract TaskXViewer createXTaskViewer(Composite var1);

    @Override
    protected WorldLabelProvider getWorldLabelProvider(TaskXViewer xTaskViewer) {
        return new XTaskEstLabelProvider(xTaskViewer);
    }

    @Override
    protected WorldContentProvider getWorldContentProvider(TaskXViewer xTaskViewer) {
        return new XTaskEstContentProvider(xTaskViewer);
    }

    public Artifact getArtifact() {
        return (Artifact)this.teamWf.getStoreObject();
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    @Override
    public Pair<Integer, String> getExtraInfoString() {
        return new Pair((Object)2, (Object)"Edit (most) fields here or double-click to open.");
    }

    public IAtsTeamWorkflow getTeamWf() {
        return this.teamWf;
    }

    public void saveToArtifact() {
    }

    public abstract Collection<TaskEstDefinition> getTaskEstDefs();

    public Collection<TaskEstDefinition> getTaskEstDefsFromTable() {
        ArrayList<TaskEstDefinition> teds = new ArrayList<TaskEstDefinition>();
        for (Object obj : this.input) {
            if (!(obj instanceof TaskEstDefinition)) continue;
            teds.add((TaskEstDefinition)obj);
        }
        return teds;
    }

    public Collection<TaskEstDefinition> getTaskEstDefsFromTableChecked() {
        ArrayList<TaskEstDefinition> teds = new ArrayList<TaskEstDefinition>();
        for (TaskEstDefinition ted : this.getTaskEstDefsFromTable()) {
            if (!ted.isChecked()) continue;
            teds.add(ted);
        }
        return teds;
    }

    private Collection<Object> getInput() {
        this.input.clear();
        Collection<TaskEstDefinition> taskDefs = this.getTaskEstDefs();
        Collection tasks = this.atsApi.getTaskService().getTasks(this.teamWf);
        block0: for (IAtsTask task : this.atsApi.getTaskService().getTasks(this.teamWf)) {
            for (TaskEstDefinition ted : this.getTaskEstDefs()) {
                if (!task.hasTag(ted.getIdString())) continue;
                taskDefs.remove(ted);
                tasks.remove(task);
                this.input.add(task);
                continue block0;
            }
        }
        this.input.addAll(tasks);
        this.input.addAll(taskDefs);
        return this.input;
    }

    @Override
    public void loadTable() {
        try {
            if (this.xTaskViewer != null && this.xTaskViewer.getContentProvider() != null) {
                this.xTaskViewer.setInput(this.getInput());
                this.xTaskViewer.refresh();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    @Override
    public void refresh() {
        if (this.xTaskViewer == null || this.xTaskViewer.getTree() == null || this.xTaskViewer.getTree().isDisposed()) {
            return;
        }
        super.refresh();
        float points = 0.0f;
        for (IAtsTask task : this.atsApi.getTaskService().getTasks(this.teamWf)) {
            points += Float.valueOf(this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)task, this.getPointsAttrType(), "0")).floatValue();
        }
        this.pointsLabel.setValueText(String.valueOf(points));
    }

    public AttributeTypeToken getPointsAttrType() {
        if (this.pointsAttrType == null) {
            IAgileTeam agileTeam = this.atsApi.getAgileService().getAgileTeam((IAtsWorkItem)this.teamWf);
            if (agileTeam != null) {
                this.pointsAttrType = this.atsApi.getAgileService().getAgileTeamPointsAttributeType(agileTeam);
            }
            if (this.pointsAttrType == null) {
                this.pointsAttrType = AtsAttributeTypes.PointsNumeric;
            }
        }
        return this.pointsAttrType;
    }

    private void updateExtraInfoLabel(final int color, final String infoStr) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)XTaskEstWidget.this.extraInfoLabel)) {
                    String currentString = XTaskEstWidget.this.extraInfoLabel.getText();
                    if (infoStr == null && currentString != null || infoStr != null && currentString == null || infoStr != null && currentString != null && !infoStr.equals(currentString)) {
                        XTaskEstWidget.this.extraInfoLabel.setText(XTaskEstWidget.INFO_STRING);
                    }
                    XTaskEstWidget.this.extraInfoLabel.setForeground(Displays.getSystemColor((int)color));
                }
            }
        });
    }

    public IStatus isValid() {
        Status returnStatus = new Status(0, ((Object)((Object)this)).getClass().getSimpleName(), "");
        try {
            int backgroundColor = 2;
            boolean inWork = false;
            for (IAtsTask task : this.atsApi.getTaskService().getTasks(this.teamWf)) {
                if (!task.isInWork()) continue;
                inWork = true;
                returnStatus = new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), "All tasks must be completed/cancelled.");
                break;
            }
            if (inWork) {
                backgroundColor = 3;
            }
            this.updateExtraInfoLabel(backgroundColor, INFO_STRING);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), ex.getLocalizedMessage());
        }
        return returnStatus;
    }
}

