/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.task.related.AbstractShowRelatedAction;
import org.eclipse.osee.ats.ide.workflow.task.related.ShowRelatedRequirementAction;
import org.eclipse.osee.ats.ide.workflow.task.related.ShowRelatedRequirementDiffsAction;
import org.eclipse.osee.ats.ide.workflow.task.related.ShowRelatedRequirementInArtifactExplorerAction;
import org.eclipse.osee.ats.ide.workflow.task.related.ShowRelatedTasksAction;
import org.eclipse.osee.ats.ide.workflow.task.related.ShowRelatedTestCasesAction;
import org.eclipse.osee.framework.core.enums.CommandGroup;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.util.RendererOption;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.MenuCmdDef;
import org.eclipse.osee.framework.ui.skynet.render.DefaultArtifactRenderer;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class AtsOpenWithTaskRenderer
extends DefaultArtifactRenderer {
    private static final String Option_TRACEABILITY = "tasks.traceability.option";
    private static final String Option_RELATED_REQ = "tasks.related.requirement.option";
    private static final String Option_RELATED_REQ_ART_EXP = "tasks.related.requirement.art.explorer.option";
    private static final String Option_REQ_DIFF = "tasks.requirement.diff.option";
    private static final String Option_RELATED_TASK = "tasks.related.task.option";

    public AtsOpenWithTaskRenderer(Map<RendererOption, Object> rendererOptions) {
        super(rendererOptions);
    }

    public AtsOpenWithTaskRenderer() {
        super(new HashMap());
    }

    public int getApplicabilityRating(PresentationType presentationType, Artifact artifact, Map<RendererOption, Object> rendererOptions) {
        int rating = -1;
        try {
            if (artifact instanceof IAtsTask && AtsApiService.get().getTaskRelatedService().isAutoGenChangeReportRelatedTask((IAtsTask)artifact)) {
                rating = this.getPresentationType(presentationType);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return rating;
    }

    public int getPresentationType(PresentationType presentationType) {
        int type = -1;
        if (presentationType.matches(new PresentationType[]{PresentationType.PREVIEW})) {
            type = 50;
        } else if (presentationType.matches(new PresentationType[]{PresentationType.F5_DIFF})) {
            type = 70;
        }
        return type;
    }

    public int minimumRanking() {
        return 20;
    }

    public String getName() {
        return "ATS Task Editor";
    }

    public void addMenuCommandDefinitions(ArrayList<MenuCmdDef> commands, Artifact artifact) {
        KeyedImage taskImage = ImageManager.create((OseeImage)AtsImage.TASK);
        commands.add(new MenuCmdDef(CommandGroup.PREVIEW, PresentationType.PREVIEW, "Show Related Test Cases", taskImage, RendererOption.OPEN_OPTION.getKey(), Option_TRACEABILITY));
        commands.add(new MenuCmdDef(CommandGroup.PREVIEW, PresentationType.PREVIEW, "Show Related Requirement", taskImage, RendererOption.OPEN_OPTION.getKey(), Option_RELATED_REQ));
        commands.add(new MenuCmdDef(CommandGroup.PREVIEW, PresentationType.PREVIEW, "Show Related Requirement in Artifact Explorer", (KeyedImage)FrameworkImage.ARTIFACT_EXPLORER, RendererOption.OPEN_OPTION.getKey(), Option_RELATED_REQ_ART_EXP));
        commands.add(new MenuCmdDef(CommandGroup.PREVIEW, PresentationType.PREVIEW, "Show Requirement Diffs - F5", taskImage, RendererOption.OPEN_OPTION.getKey(), Option_REQ_DIFF));
        commands.add(new MenuCmdDef(CommandGroup.PREVIEW, PresentationType.PREVIEW, "Show Related Tasks", taskImage, RendererOption.OPEN_OPTION.getKey(), Option_RELATED_TASK));
    }

    public AtsOpenWithTaskRenderer newInstance() {
        return new AtsOpenWithTaskRenderer(new HashMap<RendererOption, Object>());
    }

    public AtsOpenWithTaskRenderer newInstance(Map<RendererOption, Object> rendererOptions) {
        return new AtsOpenWithTaskRenderer(rendererOptions);
    }

    public void open(List<Artifact> artifacts, PresentationType presentationType) {
        final LinkedList<TaskArtifact> taskArts = new LinkedList<TaskArtifact>();
        for (Artifact art : artifacts) {
            if (!(art instanceof TaskArtifact)) continue;
            taskArts.add((TaskArtifact)art);
        }
        ISelectedAtsArtifacts selectedArtifacts = new ISelectedAtsArtifacts(){

            @Override
            public Set<Artifact> getSelectedWorkflowArtifacts() {
                return null;
            }

            @Override
            public List<Artifact> getSelectedAtsArtifacts() {
                return null;
            }

            @Override
            public List<TaskArtifact> getSelectedTaskArtifacts() {
                return taskArts;
            }
        };
        if (!taskArts.isEmpty()) {
            AbstractShowRelatedAction action = null;
            String openOption = (String)this.getRendererOptionValue(RendererOption.OPEN_OPTION);
            if (Option_RELATED_REQ.equals(openOption)) {
                action = new ShowRelatedRequirementAction(selectedArtifacts);
            } else if (Option_REQ_DIFF.equals(openOption) || presentationType.equals((Object)PresentationType.F5_DIFF)) {
                action = new ShowRelatedRequirementDiffsAction(selectedArtifacts);
            } else if (Option_RELATED_TASK.equals(openOption)) {
                action = new ShowRelatedTasksAction(selectedArtifacts);
            } else if (Option_TRACEABILITY.equals(openOption)) {
                action = new ShowRelatedTestCasesAction(selectedArtifacts);
            } else if (Option_RELATED_REQ_ART_EXP.equals(openOption)) {
                action = new ShowRelatedRequirementInArtifactExplorerAction(selectedArtifacts);
            }
            if (action != null) {
                action.run();
            }
        }
    }
}

