/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.related;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osee.ats.api.task.related.DerivedFromTaskData;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.related.AbstractShowRelatedAction;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.MutableInteger;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;

public class ShowRelatedRequirementAction
extends AbstractShowRelatedAction {
    LabelProvider relatedArtifactLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(element);
            if (art != null) {
                if (art.isHistorical()) {
                    return "[Rev:" + art.getTransaction() + "] - " + art.getName();
                }
                return "[Rev:Head] - " + art.getName();
            }
            return "";
        }
    };

    public ShowRelatedRequirementAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        super("Show Related Requirement", selectedAtsArtifacts);
    }

    public void run() {
        final Collection<IAtsTask> tasks = this.getSelectedTasks();
        if (!this.isAutoGenRelatedArtTasks(tasks)) {
            return;
        }
        final MutableInteger answer = new MutableInteger(-1);
        AbstractOperation openOp = new AbstractOperation("Show Related Requirement", "org.eclipse.osee.ats.ide"){

            protected void doWork(IProgressMonitor monitor) throws Exception {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String taskStr = tasks.size() > 1 ? "these " + tasks.size() + " tasks" : ((IAtsTask)tasks.iterator().next()).getName();
                        String dialogMessage = String.format("Are you sure you want to open the latest requirement(s) for %s?\n\nNote: Deleted requirements will default to historical version.", taskStr);
                        MessageDialog dialog = new MessageDialog(Displays.getActiveShell(), "Show Related Requirement", null, dialogMessage, 0, new String[]{"OK", "Historical", "Cancel"}, 0);
                        answer.setValue(dialog.open());
                    }
                }, (boolean)true);
                boolean loadLatest = true;
                if (answer.getValue() == 1) {
                    loadLatest = false;
                } else if (answer.getValue() == 2) {
                    return;
                }
                ShowRelatedRequirementAction.this.showRequirements(tasks, loadLatest);
            }
        };
        Operations.executeAsJob((IOperation)openOp, (boolean)true);
    }

    private void showRequirements(Collection<? extends IAtsTask> tasks, final boolean loadLatest) {
        for (final IAtsTask iAtsTask : tasks) {
            AbstractOperation loadReqs = new AbstractOperation("Show Related Requirement", "org.eclipse.osee.ats.ide"){

                protected void doWork(IProgressMonitor monitor) throws Exception {
                    DerivedFromTaskData trd = AtsApiService.get().getTaskRelatedService().getDerivedFromTaskData(iAtsTask);
                    trd.getResults().logf(String.valueOf(this.getName()) + "\n\n", new Object[0]);
                    trd.getResults().logf("Task %s \n\n", new Object[]{iAtsTask.toStringWithId()});
                    AtsApiService.get().getTaskRelatedService().populateDerivedFromTaskData(trd);
                    if (trd.getResults().isErrors()) {
                        XResultDataUI.report((XResultData)trd.getResults(), (String)this.getName());
                    } else {
                        ShowRelatedRequirementAction.this.dialog(trd, loadLatest);
                    }
                }
            };
            Operations.executeAsJob((IOperation)loadReqs, (boolean)true);
        }
    }

    private void dialog(final DerivedFromTaskData reqData, final boolean loadLatest) {
        Displays.pendInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Artifact toOpen = null;
                toOpen = reqData.isDeleted() ? AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)reqData.getHeadArtifact()) : (loadLatest ? AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)reqData.getLatestArt()) : AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)reqData.getHeadArtifact()));
                try {
                    RendererManager.open((Artifact)toOpen, (PresentationType)PresentationType.DEFAULT_OPEN);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }
}

