/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.Collection;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.WorldEditorProvider;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;

public class WorldEditorSimpleProvider
extends WorldEditorProvider {
    private final String name;
    private Collection<? extends ArtifactId> artifacts;
    private final Artifact expandToArtifact;

    public WorldEditorSimpleProvider(String name, Collection<? extends ArtifactId> collection) {
        this(name, collection, null, XNavigateComposite.TableLoadOption.None);
    }

    public WorldEditorSimpleProvider(String name, Collection<? extends ArtifactId> collection, CustomizeData customizeData, XNavigateComposite.TableLoadOption ... tableLoadOption) {
        this(name, collection, customizeData, (Artifact)null, tableLoadOption);
    }

    public WorldEditorSimpleProvider(String name, Collection<? extends ArtifactId> artifacts, CustomizeData customizeData, Artifact expandToArtifact, XNavigateComposite.TableLoadOption ... tableLoadOption) {
        super(customizeData, tableLoadOption);
        this.name = name;
        this.artifacts = artifacts;
        this.expandToArtifact = expandToArtifact;
    }

    @Override
    public IWorldEditorProvider copyProvider() {
        return new WorldEditorSimpleProvider(this.name, this.artifacts, this.customizeData, this.tableLoadOptions);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Artifact getExpandToArtifact() {
        return this.expandToArtifact;
    }

    @Override
    public Collection<? extends ArtifactId> performSearch(WorldSearchItem.SearchType searchType) {
        if (searchType == WorldSearchItem.SearchType.ReSearch) {
            this.artifacts = ArtifactQuery.getArtifactListFrom(this.artifacts, (BranchId)AtsApiService.get().getAtsBranch());
        }
        return this.artifacts;
    }
}

