/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.world.search.UserSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class MyWorldSearchItem
extends UserSearchItem {
    public MyWorldSearchItem(String name, boolean currentUser) {
        this(name, (AtsUser)null);
        this.setUseCurrentUser(currentUser);
    }

    public MyWorldSearchItem(String name, AtsUser user) {
        super(name, user, AtsImage.GLOBE);
    }

    public MyWorldSearchItem(MyWorldSearchItem myWorldSearchItem) {
        super(myWorldSearchItem);
    }

    @Override
    public Collection<Artifact> searchIt(AtsUser user) {
        Set<Artifact> assigned = AtsEditors.getAssigned(user);
        HashSet<Artifact> results = new HashSet<Artifact>(assigned.size());
        for (Artifact artifact : assigned) {
            if (!(artifact instanceof AbstractWorkflowArtifact)) continue;
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
                results.add(((TaskArtifact)artifact).getParentTeamWorkflow());
                continue;
            }
            results.add(artifact);
        }
        return results;
    }

    @Override
    public WorldUISearchItem copy() {
        return new MyWorldSearchItem(this);
    }
}

