/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.VersionLockedType;
import org.eclipse.osee.ats.api.version.VersionReleaseType;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionDialog;
import org.eclipse.osee.ats.ide.util.widgets.dialog.VersionListDialog;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;

public class VersionTargetedForTeamSearchItem
extends WorldUISearchItem {
    private final IAtsVersion versionArt;
    private IAtsVersion selectedVersionArt;
    private final boolean returnAction;
    private final IAtsTeamDefinition teamDef;

    public VersionTargetedForTeamSearchItem(IAtsTeamDefinition teamDef, IAtsVersion versionArt, boolean returnAction, WorldSearchItem.LoadView loadView) {
        this(null, teamDef, versionArt, returnAction, loadView);
    }

    public VersionTargetedForTeamSearchItem(String name, IAtsTeamDefinition teamDef, IAtsVersion versionArt, boolean returnAction, WorldSearchItem.LoadView loadView) {
        super(name != null ? name : String.valueOf(returnAction ? "Actions" : "Workflows") + " Targeted-For Version", loadView, AtsImage.VERSION);
        this.teamDef = teamDef;
        this.versionArt = versionArt;
        this.returnAction = returnAction;
    }

    public VersionTargetedForTeamSearchItem(VersionTargetedForTeamSearchItem versionTargetedForTeamSearchItem) {
        super(versionTargetedForTeamSearchItem, AtsImage.VERSION);
        this.versionArt = versionTargetedForTeamSearchItem.versionArt;
        this.returnAction = versionTargetedForTeamSearchItem.returnAction;
        this.teamDef = versionTargetedForTeamSearchItem.teamDef;
    }

    @Override
    public String getSelectedName(WorldSearchItem.SearchType searchType) {
        if (this.getSearchVersionArtifact() != null) {
            return String.valueOf(super.getName()) + " - " + this.getSearchVersionArtifact();
        }
        return "";
    }

    public IAtsVersion getSearchVersionArtifact() {
        if (this.versionArt != null) {
            return this.versionArt;
        }
        return this.selectedVersionArt;
    }

    @Override
    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        if (this.getSearchVersionArtifact() == null) {
            throw new OseeArgumentException("Invalid release version", new Object[0]);
        }
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        for (IAtsTeamWorkflow team : AtsApiService.get().getVersionService().getTargetedForTeamWorkflows(this.getSearchVersionArtifact())) {
            if (this.returnAction) {
                IAtsAction parentAction = ((TeamWorkFlowArtifact)team.getStoreObject()).getParentAction();
                if (parentAction == null) continue;
                arts.add((Artifact)parentAction);
                continue;
            }
            arts.add((TeamWorkFlowArtifact)team.getStoreObject());
        }
        if (this.isCancelled()) {
            return EMPTY_SET;
        }
        return arts;
    }

    @Override
    public void performUI(WorldSearchItem.SearchType searchType) {
        super.performUI(searchType);
        if (searchType == WorldSearchItem.SearchType.ReSearch && this.selectedVersionArt != null) {
            return;
        }
        if (this.versionArt != null) {
            return;
        }
        try {
            FilteredTreeDialog dialog;
            IAtsTeamDefinition selectedTeamDef = this.teamDef;
            if (this.versionArt == null && selectedTeamDef == null) {
                dialog = new TeamDefinitionDialog();
                dialog.setInput(AtsApiService.get().getTeamDefinitionService().getTeamReleaseableDefinitions(Active.Both));
                int result = dialog.open();
                if (result == 0) {
                    selectedTeamDef = (IAtsTeamDefinition)dialog.getSelectedFirst();
                } else {
                    this.cancelled = true;
                }
            }
            if (this.versionArt == null && selectedTeamDef != null && (dialog = new VersionListDialog("Select Version", "Select Version", AtsApiService.get().getVersionService().getVersions(selectedTeamDef, VersionReleaseType.Both, VersionLockedType.Both))).open() == 0) {
                this.selectedVersionArt = (IAtsVersion)dialog.getSelectedFirst();
                return;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        this.cancelled = true;
    }

    @Override
    public WorldUISearchItem copy() {
        return new VersionTargetedForTeamSearchItem(this);
    }
}

