/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.ws;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.ui.ws.AWorkspace;

public final class AJavaProject {
    private static final Map<IJavaProject, IClasspathEntry[]> cachedPath = new HashMap<IJavaProject, IClasspathEntry[]>();
    private static final Pattern JAVA_PACKAGE_PATTERN = Pattern.compile(".*?package\\s*(.*?);.*", 32);
    private static final Matcher JAVA_PACKAGE_MATCHER = JAVA_PACKAGE_PATTERN.matcher("");

    private AJavaProject() {
    }

    private static IClasspathEntry[] localGetResolvedClasspath(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] paths = cachedPath.get(javaProject);
        if (paths == null) {
            paths = javaProject.getResolvedClasspath(true);
            cachedPath.put(javaProject, paths);
        }
        return paths;
    }

    public static String getClassName(String file) {
        String classname = null;
        try {
            String packageName = "";
            File java = new File(file);
            packageName = AJavaProject.getJavaPackage(java);
            if (packageName.length() > 0) {
                packageName = String.valueOf(packageName) + ".";
            }
            classname = packageName = String.valueOf(packageName) + java.getName().replace(".java", "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classname;
    }

    public static String getJavaPackage(File javaFile) throws IOException {
        String javaFileContent = Lib.fileToString((File)javaFile);
        Matcher matcher = JAVA_PACKAGE_MATCHER;
        matcher.reset(javaFileContent);
        return matcher.matches() ? matcher.group(1) : "";
    }

    public static ArrayList<File> getJavaProjectProjectDependancies(IJavaProject javaProject) {
        ArrayList<File> urls = new ArrayList<File>();
        try {
            IClasspathEntry[] paths = AJavaProject.localGetResolvedClasspath(javaProject);
            int i = 0;
            while (i < paths.length) {
                if (paths[i].getEntryKind() == 1) {
                    if (!paths[i].getPath().toFile().exists()) {
                        File file = null;
                        file = new File(AWorkspace.getWorkspacePath().concat(paths[i].getPath().toOSString()));
                        if (file.exists()) {
                            urls.add(file);
                        }
                    }
                } else if (paths[i].getEntryKind() == 2) {
                    urls.add(new File(AWorkspace.getWorkspacePath().concat(paths[i].getPath().toFile().getPath().concat(String.valueOf(File.separator) + "bin" + File.separator))));
                } else if (paths[i].getEntryKind() == 3) {
                    File projectlocation = javaProject.getProject().getLocation().toFile();
                    File projecttricky = javaProject.getProject().getFullPath().toFile();
                    IPath output = paths[i].getOutputLocation();
                    File fileLocation = output == null ? javaProject.getOutputLocation().toFile() : paths[i].getOutputLocation().toFile();
                    String realLocation = fileLocation.toString().replace(projecttricky.toString(), projectlocation.toString());
                    urls.add(new File(realLocation));
                }
                ++i;
            }
        }
        catch (JavaModelException ex) {
            ex.printStackTrace();
        }
        return urls;
    }
}

