/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writers.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class GenericMethodInvoker<T> {
    Method method;
    List<Object> arguments = new ArrayList<Object>();
    private final T realInstance;

    public GenericMethodInvoker(T obj) {
        this.realInstance = obj;
    }

    public Object invoke(T invoker) {
        try {
            Object[] args = this.arguments.toArray();
            return this.method.invoke(invoker, args);
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean set(String methodName, List<Object> args) {
        Method[] methodArray = this.realInstance.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName)) {
                Type[] pType = m.getGenericParameterTypes();
                boolean argsMatch = false;
                if (pType.length == args.size()) {
                    int i = 0;
                    while (i < pType.length) {
                        block11: {
                            Class<Object> reflectedTypeClass = this.getClassForType(pType[i]);
                            if (reflectedTypeClass == null) {
                                argsMatch = false;
                                break;
                            }
                            Class<?> knownArgClass = args.get(i).getClass();
                            if (reflectedTypeClass.isAssignableFrom(knownArgClass)) {
                                argsMatch = true;
                                this.arguments.add(args.get(i));
                            } else {
                                if (reflectedTypeClass.isArray()) {
                                    Object array = Array.newInstance(knownArgClass, 1);
                                    if (reflectedTypeClass.isAssignableFrom(array.getClass())) {
                                        Array.set(array, 0, args.get(i));
                                        this.arguments.add(array);
                                        argsMatch = true;
                                        break block11;
                                    } else {
                                        argsMatch = false;
                                        break;
                                    }
                                }
                                argsMatch = false;
                                this.arguments.clear();
                                break;
                            }
                        }
                        argsMatch = true;
                        ++i;
                    }
                }
                if (argsMatch) {
                    this.method = m;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public Class<? extends Object> getClassForType(Type type) {
        Class<?> clazz = null;
        clazz = type instanceof ParameterizedType ? this.getClassFromName(((ParameterizedType)type).getRawType().getTypeName()) : this.getClassFromName(type.getTypeName());
        return clazz;
    }

    private Class<?> getClassFromName(String name) {
        Class clazz = null;
        try {
            if (name.equals("boolean")) {
                clazz = Boolean.class;
            } else if (name.equals("int")) {
                clazz = Integer.class;
            } else if (name.equals("long")) {
                clazz = Long.class;
            } else if (name.equals("float")) {
                clazz = Float.class;
            } else if (name.equals("double")) {
                clazz = Double.class;
            } else if (name.endsWith("[]")) {
                name = name.substring(0, name.length() - 2);
                clazz = Class.forName("[L" + name + ";");
            } else {
                clazz = Class.forName(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return clazz;
        }
        return clazz;
    }
}

