/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.handlers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaRelation;
import org.eclipse.osee.orcs.db.internal.loader.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class RelationSqlHandler
extends SqlHandler<CriteriaRelation> {
    private CriteriaRelation criteria;
    private String jIdAlias;
    private String jTypeIdAlias;
    private String jArtAlias;
    private String relationAlias;
    private String txsAlias;
    private Collection<RelationTypeToken> typeIds;
    private AbstractJoinQuery joinIdQuery;
    private AbstractJoinQuery joinTypeQuery;

    @Override
    public int getPriority() {
        return SqlHandlerPriority.RELATION_LOADER.ordinal();
    }

    @Override
    public void setData(CriteriaRelation criteria) {
        this.criteria = criteria;
    }

    @Override
    public void writeSelectFields(AbstractSqlWriter writer) {
        writer.writeCommaIfNotFirst();
        writer.write("%s.rel_link_id, %s.rel_link_type_id, %s.a_art_id, %s.b_art_id, %s.rationale", this.relationAlias, this.relationAlias, this.relationAlias, this.relationAlias, this.relationAlias);
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.jArtAlias = writer.addTable(OseeDb.OSEE_JOIN_ID4_TABLE);
        if (this.criteria.getIds().size() > 1) {
            this.jIdAlias = writer.addTable(OseeDb.OSEE_JOIN_ID_TABLE);
        }
        this.typeIds = this.getLocalTypeIds();
        if (this.typeIds.size() > 1) {
            this.jTypeIdAlias = writer.addTable(OseeDb.OSEE_JOIN_ID_TABLE);
        }
        this.relationAlias = writer.addTable(OseeDb.RELATION_TABLE);
        this.txsAlias = writer.addTable(OseeDb.TXS_TABLE, ObjectType.RELATION);
    }

    private Collection<RelationTypeToken> getLocalTypeIds() {
        HashSet<RelationTypeToken> toReturn = new HashSet<RelationTypeToken>();
        for (RelationTypeToken relationTypeToken : this.criteria.getTypes()) {
            toReturn.add(relationTypeToken);
        }
        return toReturn;
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.write("(%s.a_art_id = %s.id2 OR %s.b_art_id = %s.id2)", this.relationAlias, this.jArtAlias, this.relationAlias, this.jArtAlias);
        writer.write(" AND ");
        writer.write(this.jArtAlias);
        writer.write(".query_id = ?");
        writer.addParameter(this.criteria.getQueryId());
        Collection<RelationId> ids = this.criteria.getIds();
        if (!ids.isEmpty()) {
            writer.write(" AND ");
            if (ids.size() > 1) {
                this.joinIdQuery = writer.writeJoin(ids);
                writer.write(this.relationAlias);
                writer.write(".rel_link_id = ");
                writer.write(this.jIdAlias);
                writer.write(".id AND ");
                writer.write(this.jIdAlias);
                writer.write(".query_id = ?");
                writer.addParameter(this.joinIdQuery.getQueryId());
            } else {
                writer.write(this.relationAlias);
                writer.write(".rel_link_id = ?");
                writer.addParameter(ids.iterator().next());
            }
        }
        if (!this.typeIds.isEmpty()) {
            writer.write(" AND ");
            if (this.typeIds.size() > 1) {
                this.joinTypeQuery = writer.writeJoin(ids);
                writer.write(this.relationAlias);
                writer.write(".rel_link_type_id = ");
                writer.write(this.jTypeIdAlias);
                writer.write(".id AND ");
                writer.write(this.jTypeIdAlias);
                writer.write(".query_id = ?");
                writer.addParameter(this.joinTypeQuery.getQueryId());
            } else {
                writer.write(this.relationAlias);
                writer.write(".rel_link_type_id = ?");
                writer.addParameter(this.typeIds.iterator().next());
            }
        }
        writer.write(" AND ");
        writer.write(this.relationAlias);
        writer.write(".gamma_id = ");
        writer.write(this.txsAlias);
        writer.write(".gamma_id");
        writer.write("\n AND ");
        writer.writeTxBranchFilter(this.txsAlias);
    }
}

