/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.osee.ats.rest.AtsApiServer;
import org.eclipse.osee.ats.rest.internal.agile.AgileEndpointImpl;
import org.eclipse.osee.ats.rest.internal.agile.operations.SprintDataUiOperation;
import org.eclipse.osee.ats.rest.internal.agile.operations.SprintSummaryOperation;
import org.eclipse.osee.ats.rest.internal.config.ActionableItemResource;
import org.eclipse.osee.ats.rest.internal.config.AtsConfigEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.ConvertAtsConfigGuidAttributes;
import org.eclipse.osee.ats.rest.internal.config.ConvertCreateUpdateAtsConfig;
import org.eclipse.osee.ats.rest.internal.config.ConvertResource;
import org.eclipse.osee.ats.rest.internal.config.CountryEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.CountryResource;
import org.eclipse.osee.ats.rest.internal.config.InsertionActivityEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.InsertionActivityResource;
import org.eclipse.osee.ats.rest.internal.config.InsertionEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.InsertionResource;
import org.eclipse.osee.ats.rest.internal.config.ProgramEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.ProgramResource;
import org.eclipse.osee.ats.rest.internal.config.ReportResource;
import org.eclipse.osee.ats.rest.internal.config.TeamResource;
import org.eclipse.osee.ats.rest.internal.config.UserResource;
import org.eclipse.osee.ats.rest.internal.config.VersionResource;
import org.eclipse.osee.ats.rest.internal.cpa.CpaResource;
import org.eclipse.osee.ats.rest.internal.cpa.CpaServiceRegistry;
import org.eclipse.osee.ats.rest.internal.notify.AtsNotifyEndpointImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsProductLineEndpointImpl;
import org.eclipse.osee.ats.rest.internal.util.health.AtsHealthEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsActionEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsActionUiEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsAttributeEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsTaskEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsTeamWfEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsWorkPackageEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.StateResource;
import org.eclipse.osee.ats.rest.internal.workitem.operations.ConvertWorkDefinitionToAttributes;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.JiraEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.workdef.AtsWorkDefEndpointImpl;
import org.eclipse.osee.ats.rest.internal.world.AtsWorldEndpointImpl;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.ResourceRegistry;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.template.engine.OseeTemplateTokens;

@ApplicationPath(value="ats")
public class AtsApplication
extends Application {
    private final Set<Object> singletons = new HashSet<Object>();
    private Log logger;
    private static OrcsApi orcsApi;
    private AtsApiServer atsApiServer;
    private CpaServiceRegistry cpaRegistry;
    private JdbcService jdbcService;
    private ExecutorAdmin executorAdmin;

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        AtsApplication.orcsApi = orcsApi;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setAtsApiServer(AtsApiServer atsApiServer) {
        this.atsApiServer = atsApiServer;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setCpaServiceRegistry(CpaServiceRegistry cpaRegistry) {
        this.cpaRegistry = cpaRegistry;
    }

    public void start() {
        ResourceRegistry registry = new ResourceRegistry();
        OseeTemplateTokens.register((IResourceRegistry)registry);
        ConvertCreateUpdateAtsConfig atsConfgConversion = new ConvertCreateUpdateAtsConfig(orcsApi);
        this.atsApiServer.addAtsDatabaseConversion(atsConfgConversion);
        this.atsApiServer.addAtsDatabaseConversion(new ConvertAtsConfigGuidAttributes());
        this.atsApiServer.addAtsDatabaseConversion(new ConvertWorkDefinitionToAttributes());
        this.atsApiServer.getAgileSprintHtmlReportOperations().add(new SprintSummaryOperation(this.atsApiServer, (IResourceRegistry)registry));
        this.atsApiServer.getAgileSprintHtmlReportOperations().add(new SprintDataUiOperation(this.atsApiServer, (IResourceRegistry)registry));
        this.singletons.add(new VersionResource(this.atsApiServer, orcsApi));
        this.singletons.add(new TeamResource(this.atsApiServer, orcsApi));
        this.singletons.add(new ActionableItemResource(this.atsApiServer, orcsApi));
        this.singletons.add(new CountryResource(this.atsApiServer, orcsApi));
        this.singletons.add(new ProgramResource(this.atsApiServer, orcsApi));
        this.singletons.add(new InsertionResource(this.atsApiServer, orcsApi));
        this.singletons.add(new InsertionActivityResource(this.atsApiServer, orcsApi));
        this.singletons.add(new StateResource(this.atsApiServer));
        this.singletons.add(new ConvertResource(this.atsApiServer));
        this.singletons.add(new CpaResource(orcsApi, this.atsApiServer, this.cpaRegistry));
        this.singletons.add(new UserResource(this.atsApiServer.getUserService()));
        this.singletons.add(new AtsActionEndpointImpl(this.atsApiServer, orcsApi));
        this.singletons.add(new AtsWorldEndpointImpl(this.atsApiServer));
        this.singletons.add(new AtsHealthEndpointImpl(this.atsApiServer, this.jdbcService));
        this.singletons.add(new AtsWorkDefEndpointImpl(this.atsApiServer, orcsApi));
        this.singletons.add(new AgileEndpointImpl(this.atsApiServer, (IResourceRegistry)registry, this.jdbcService, orcsApi));
        this.singletons.add(new CountryEndpointImpl(this.atsApiServer));
        this.singletons.add(new ProgramEndpointImpl(this.atsApiServer));
        this.singletons.add(new InsertionEndpointImpl(this.atsApiServer));
        this.singletons.add(new InsertionActivityEndpointImpl(this.atsApiServer));
        this.singletons.add(new AtsTaskEndpointImpl(this.atsApiServer));
        this.singletons.add(new AtsConfigEndpointImpl(this.atsApiServer, orcsApi, this.executorAdmin));
        this.singletons.add(new AtsProductLineEndpointImpl(this.atsApiServer, orcsApi));
        this.singletons.add(new AtsNotifyEndpointImpl(this.atsApiServer));
        this.singletons.add(new AtsWorkPackageEndpointImpl(this.atsApiServer));
        this.singletons.add(new AtsTeamWfEndpointImpl(this.atsApiServer));
        this.singletons.add(new AtsAttributeEndpointImpl(this.atsApiServer, orcsApi));
        this.singletons.add(new JiraEndpointImpl(this.atsApiServer));
        this.singletons.add(new AtsActionUiEndpointImpl(this.atsApiServer, this.logger));
        this.singletons.add(new ReportResource(orcsApi, this.atsApiServer));
        Thread loadConfig = new Thread("Load ATS Config"){

            @Override
            public void run() {
                AtsApplication.this.atsApiServer.getConfigService().getConfigurations();
            }
        };
        loadConfig.start();
        this.logger.warn("ATS Application Started - %s", new Object[]{System.getProperty("OseeApplicationServer")});
    }

    public void stop() {
        this.singletons.clear();
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public static OrcsApi getOrcsApi() {
        return orcsApi;
    }
}

