/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;

public class OseeData {
    public static final String ART_ID_SEQ = "SKYNET_ART_ID_SEQ";
    public static final String ATTR_ID_SEQ = "SKYNET_ATTR_ID_SEQ";
    public static final String REL_LINK_ID_SEQ = "SKYNET_REL_LINK_ID_SEQ";
    public static final String GAMMA_ID_SEQ = "SKYNET_GAMMA_ID_SEQ";
    public static final String BRANCH_ID_SEQ = "SKYNET_BRANCH_ID_SEQ";
    public static final String TRANSACTION_ID_SEQ = "SKYNET_TRANSACTION_ID_SEQ";
    private static final String OSEE_DATA_FOLDER_NAME = "osee.data";
    private static IProject project;

    private OseeData() {
    }

    public static synchronized void ensureProjectReady() {
        if (project == null) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            project = workspaceRoot.getProject(OSEE_DATA_FOLDER_NAME);
        }
        if (!project.exists()) {
            try {
                project.create(null);
                project.open(null);
            }
            catch (CoreException ex) {
                OseeLog.log(OseeData.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        if (!project.isOpen()) {
            OseeLog.logf(OseeData.class, (Level)Level.INFO, (String)"[%s] project is closed; re-opening", (Object[])new Object[]{OSEE_DATA_FOLDER_NAME});
            try {
                project.open(null);
            }
            catch (CoreException e) {
                OseeLog.log(OseeData.class, (Level)Level.SEVERE, (Throwable)e);
            }
        }
    }

    public static IProject getProject() {
        OseeData.ensureProjectReady();
        return project;
    }

    public static IPath getPath() {
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        return workspacePath.append(OSEE_DATA_FOLDER_NAME);
    }

    public static File getFile(String filename) {
        OseeData.ensureProjectReady();
        return new File(OseeData.getPath().toFile(), filename);
    }

    public static File getWorkspaceFile(String path) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return new File(workspaceRoot.getFile((IPath)new Path(path)).getLocation().toString());
    }

    public static IFile getIFile(String fileName) {
        return OseeData.getProject().getFile(fileName);
    }

    public static IFile getIFile(String fileName, InputStream in) {
        return OseeData.getIFile(fileName, in, false);
    }

    public static IFile getIFile(String fileName, InputStream in, boolean overwrite) {
        IFile iFile = OseeData.getProject().getFile(fileName);
        if (!iFile.exists() || overwrite) {
            OseeData.writeToFile(iFile, in);
        }
        return iFile;
    }

    public static void writeToFile(IFile file, InputStream in) {
        try {
            if (file.exists()) {
                file.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
                file.setContents(in, true, false, null);
            } else {
                file.create(in, true, null);
                in.close();
            }
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public static IFolder getFolder(String name) {
        try {
            IFolder folder = OseeData.getProject().getFolder(name);
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            return folder;
        }
        catch (CoreException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static File writeToFile(String filename, String html) {
        File outFile = OseeData.getFile(filename);
        try {
            Lib.writeStringToFile((String)html, (File)outFile);
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
        return outFile;
    }
}

