/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceDifferenceReportApi;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceEnumerationApi;
import org.eclipse.osee.mim.InterfaceEnumerationSetApi;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.MimDifferenceReport;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class InterfaceDifferenceReportApiImpl
implements InterfaceDifferenceReportApi {
    private BranchId branch1;
    private BranchId branch2;
    private final OrcsApi orcsApi;
    private final InterfaceNodeViewApi interfaceNodeApi;
    private final InterfaceConnectionViewApi interfaceConnectionApi;
    private final InterfaceMessageApi interfaceMessageApi;
    private final InterfaceSubMessageApi interfaceSubMessageApi;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceElementApi interfaceElementApi;
    private final InterfacePlatformTypeApi interfacePlatformApi;
    private final InterfaceEnumerationSetApi interfaceEnumerationSetApi;
    private final InterfaceEnumerationApi interfaceEnumerationApi;
    private Map<ArtifactId, List<ChangeItem>> changeMap;
    private Map<ArtifactId, List<ChangeItem>> nodeMap;
    private Map<ArtifactId, List<ChangeItem>> connectionMap;
    private Map<ArtifactId, List<ChangeItem>> messageMap;
    private Map<ArtifactId, List<ChangeItem>> submessageMap;
    private Map<ArtifactId, List<ChangeItem>> structureMap;
    private Map<ArtifactId, List<ChangeItem>> elementMap;
    private Map<ArtifactId, List<ChangeItem>> typeMap;
    private Map<ArtifactId, List<ChangeItem>> enumMap;
    private MimDifferenceReport diffReport;

    InterfaceDifferenceReportApiImpl(OrcsApi orcsApi, InterfaceNodeViewApi interfaceNodeApi, InterfaceConnectionViewApi interfaceConnectionViewApi, InterfaceMessageApi interfaceMessageApi, InterfaceSubMessageApi interfaceSubMessageApi, InterfaceStructureApi interfaceStructureApi, InterfaceElementApi interfaceElementApi, InterfacePlatformTypeApi interfacePlatformApi, InterfaceEnumerationSetApi interfaceEnumerationSetApi, InterfaceEnumerationApi interfaceEnumerationApi) {
        this.orcsApi = orcsApi;
        this.interfaceNodeApi = interfaceNodeApi;
        this.interfaceConnectionApi = interfaceConnectionViewApi;
        this.interfaceMessageApi = interfaceMessageApi;
        this.interfaceSubMessageApi = interfaceSubMessageApi;
        this.interfaceStructureApi = interfaceStructureApi;
        this.interfaceElementApi = interfaceElementApi;
        this.interfacePlatformApi = interfacePlatformApi;
        this.interfaceEnumerationSetApi = interfaceEnumerationSetApi;
        this.interfaceEnumerationApi = interfaceEnumerationApi;
    }

    @Override
    public MimDifferenceReport getDifferenceReport(BranchId branch1, BranchId branch2) {
        this.branch1 = branch1;
        this.branch2 = branch2;
        this.changeMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.nodeMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.connectionMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.messageMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.submessageMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.structureMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.elementMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.typeMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.enumMap = new HashMap<ArtifactId, List<ChangeItem>>();
        this.diffReport = new MimDifferenceReport();
        TransactionToken sourceTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch1)).getResults().getExactlyOne();
        TransactionToken destinationTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch2)).getResults().getExactlyOne();
        List changes = this.orcsApi.getBranchOps().compareBranch(sourceTx, destinationTx);
        changes.stream().filter(c -> c.getChangeType().getId() == ChangeType.Artifact.getId()).forEach(c -> this.addChangeToMap((ChangeItem)c));
        for (ChangeItem change : changes) {
            List<ChangeItem> list = this.getListOrDefault(this.changeMap, change.getArtId().getId());
            list.add(change);
            this.changeMap.put(change.getArtId(), list);
        }
        for (ArtifactId artId : this.nodeMap.keySet()) {
            this.processNode(artId);
        }
        for (ArtifactId artId : this.connectionMap.keySet()) {
            this.processConnection(artId);
        }
        for (ArtifactId artId : this.messageMap.keySet()) {
            this.processMessage(artId);
        }
        for (ArtifactId artId : this.submessageMap.keySet()) {
            this.processSubMessage(artId);
        }
        for (ArtifactId artId : this.structureMap.keySet()) {
            this.processStructure(artId);
        }
        for (ArtifactId artId : this.elementMap.keySet()) {
            this.processElement(artId, ArtifactId.SENTINEL);
        }
        for (ArtifactId artId : this.typeMap.keySet()) {
            List<InterfaceStructureElementToken> elements = this.interfaceElementApi.getElementsByType(this.getBranchId(artId), artId);
            for (InterfaceStructureElementToken element : elements) {
                this.processElement(ArtifactId.valueOf((Long)element.getId()), artId, element);
            }
        }
        for (ArtifactId artId : this.enumMap.keySet()) {
            this.processEnumeration(artId);
        }
        return this.diffReport;
    }

    private void processNode(ArtifactId nodeId) {
        List<ChangeItem> changeItems = this.changeMap.get(nodeId);
        InterfaceNode node = this.interfaceNodeApi.get(this.getBranchId(nodeId), nodeId);
        if (node.isValid()) {
            this.diffReport.addItem(node, changeItems);
            this.diffReport.getNodes().add(nodeId);
        }
    }

    private void processConnection(ArtifactId connectionId) {
        InterfaceConnection connection = this.interfaceConnectionApi.get(this.getBranchId(connectionId), connectionId);
        if (connection.isValid()) {
            this.diffReport.addItem(connection, this.getListOrDefault(this.changeMap, connectionId.getId()));
            this.diffReport.getConnections().add(connectionId);
        }
    }

    private void processMessage(ArtifactId messageId) {
        InterfaceMessageToken message = this.interfaceMessageApi.getWithAllParentRelations(this.getBranchId(messageId), messageId);
        if (message.isValid()) {
            this.diffReport.addItem(message, this.getListOrDefault(this.changeMap, messageId.getId()));
            this.addMessageParent(message);
            this.diffReport.getMessages().add(messageId);
        }
    }

    private void processSubMessage(ArtifactId submessageId) {
        InterfaceSubMessageToken subMessage = this.interfaceSubMessageApi.getWithAllParentRelations(this.getBranchId(submessageId), submessageId);
        if (subMessage.isValid()) {
            this.diffReport.addItem(subMessage, this.getListOrDefault(this.changeMap, submessageId.getId()));
            this.addSubMessageParents(subMessage);
            this.diffReport.getSubMessages().add(submessageId);
        }
    }

    private void processStructure(ArtifactId structureId) {
        InterfaceStructureToken structure = this.interfaceStructureApi.getWithAllParentRelations(this.getBranchId(structureId), structureId);
        if (structure.isValid()) {
            this.diffReport.addItem(structure, this.getListOrDefault(this.changeMap, structureId.getId()));
            this.addStructureParents(structure);
            this.diffReport.getStructures().add(structureId);
        }
    }

    private void processElement(ArtifactId elementId, ArtifactId typeId) {
        InterfaceStructureElementToken element = this.interfaceElementApi.get(this.getBranchId(elementId), elementId);
        this.processElement(elementId, typeId, element);
    }

    private void processElement(ArtifactId elementId, ArtifactId typeId, InterfaceStructureElementToken element) {
        if (element.isValid()) {
            this.diffReport.addItem(element, this.getListOrDefault(this.changeMap, element.getId()));
            if (typeId.isValid()) {
                this.diffReport.addItem(element, this.getListOrDefault(this.changeMap, typeId.getId()));
            }
            if (!this.diffReport.hasParents(elementId)) {
                InterfaceStructureElementToken elementWithParentRelations = this.interfaceElementApi.getWithAllParentRelations(this.branch1, elementId);
                this.addElementParents(elementWithParentRelations);
            }
            this.diffReport.getElements().add(elementId);
        }
    }

    private void processEnumeration(ArtifactId enumId) {
        InterfaceEnumeration enumeration = this.interfaceEnumerationApi.get(this.getBranchId(enumId), enumId, Arrays.asList(CoreRelationTypes.InterfaceEnumeration_EnumerationSet, CoreRelationTypes.InterfacePlatformTypeEnumeration_Element, CoreRelationTypes.InterfaceElementPlatformType_Element));
        List enumSets = enumeration.getArtifactReadable().getRelatedList(CoreRelationTypes.InterfaceEnumeration_EnumerationSet).stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceEnumerationSet((ArtifactReadable)a)).collect(Collectors.toList());
        for (InterfaceEnumerationSet enumSet : enumSets) {
            ArtifactId enumSetId = ArtifactId.valueOf((Long)enumSet.getId());
            InterfaceEnumerationSet populatedSet = this.interfaceEnumerationSetApi.get(this.getBranchId(enumId), enumSetId);
            this.diffReport.addItem(populatedSet, this.getListOrDefault(this.changeMap, enumId.getId()));
            this.diffReport.getEnumSets().add(enumSetId);
            this.addEnumSetParents(enumSet);
        }
    }

    private void addMessageParent(InterfaceMessageToken message) {
        ArtifactId messageId = ArtifactId.valueOf((Long)message.getId());
        if (!this.diffReport.hasParents(messageId)) {
            InterfaceConnection connection = this.interfaceConnectionApi.getRelatedFromMessage(message);
            ArtifactId connectionId = ArtifactId.valueOf((Long)connection.getId());
            this.diffReport.addParent(messageId, connectionId);
            this.diffReport.addItem(connection);
        }
    }

    private void addSubMessageParents(InterfaceSubMessageToken subMessage) {
        ArtifactId subMessageId = ArtifactId.valueOf((Long)subMessage.getId());
        if (!this.diffReport.hasParents(subMessageId)) {
            List<InterfaceMessageToken> messages = this.interfaceMessageApi.getAllRelatedFromSubMessage(subMessage);
            for (InterfaceMessageToken message : messages) {
                ArtifactId messageId = ArtifactId.valueOf((Long)message.getId());
                this.diffReport.addParent(subMessageId, messageId);
                this.diffReport.addItem(message);
                this.addMessageParent(message);
            }
        }
    }

    private void addStructureParents(InterfaceStructureToken structure) {
        ArtifactId structureId = ArtifactId.valueOf((Long)structure.getId());
        if (!this.diffReport.hasParents(structureId)) {
            List<InterfaceSubMessageToken> subMessages = this.interfaceSubMessageApi.getAllRelatedFromStructure(structure);
            for (InterfaceSubMessageToken subMessage : subMessages) {
                ArtifactId subMessageId = ArtifactId.valueOf((Long)subMessage.getId());
                this.diffReport.addParent(structureId, subMessageId);
                this.diffReport.addItem(subMessage);
                this.addSubMessageParents(subMessage);
            }
        }
    }

    private void addElementParents(InterfaceStructureElementToken element) {
        ArtifactId elementId = ArtifactId.valueOf((Long)element.getId());
        if (!this.diffReport.hasParents(elementId)) {
            List<InterfaceStructureToken> structures = this.interfaceStructureApi.getAllRelatedFromElement(element);
            for (InterfaceStructureToken structure : structures) {
                ArtifactId structureId = ArtifactId.valueOf((Long)structure.getId());
                this.diffReport.addParent(elementId, structureId);
                this.diffReport.addItem(structure);
                this.addStructureParents(structure);
            }
        }
    }

    private void addEnumSetParents(InterfaceEnumerationSet enumSet) {
        ArtifactId enumSetId = ArtifactId.valueOf((Long)enumSet.getId());
        if (!this.diffReport.hasParents(enumSetId)) {
            for (PlatformTypeToken pType : this.interfacePlatformApi.getAllFromEnumerationSet(enumSet)) {
                ArtifactId pTypeId = ArtifactId.valueOf((Long)pType.getId());
                this.diffReport.addParent(enumSetId, pTypeId);
                for (InterfaceStructureElementToken element : this.interfaceElementApi.getAllFromPlatformType(pType)) {
                    this.processElement(ArtifactId.valueOf((Long)element.getId()), ArtifactId.SENTINEL);
                }
            }
        }
    }

    private BranchId getBranchId(ArtifactId artId) {
        List<ChangeItem> changes = this.changeMap.get(artId);
        if (changes == null || changes.isEmpty()) {
            return this.branch1;
        }
        ChangeItem change = changes.stream().filter(c -> c.getChangeType().getId() == ChangeType.Artifact.getId()).findFirst().orElse(null);
        return change != null && change.isDeleted() ? this.branch2 : this.branch1;
    }

    private List<ChangeItem> getListOrDefault(Map<ArtifactId, List<ChangeItem>> changeMap, Long artId) {
        return changeMap.getOrDefault(ArtifactId.valueOf((Long)artId), new LinkedList());
    }

    private void addChangeToMap(ChangeItem changeItem) {
        Map<ArtifactId, List<ChangeItem>> map = null;
        long itemTypeId = changeItem.getItemTypeId().getId();
        if (itemTypeId == CoreArtifactTypes.InterfaceNode.getId()) {
            map = this.nodeMap;
        } else if (itemTypeId == CoreArtifactTypes.InterfaceConnection.getId()) {
            map = this.connectionMap;
        } else if (itemTypeId == CoreArtifactTypes.InterfaceMessage.getId()) {
            map = this.messageMap;
        } else if (itemTypeId == CoreArtifactTypes.InterfaceSubMessage.getId()) {
            map = this.submessageMap;
        } else if (itemTypeId == CoreArtifactTypes.InterfaceStructure.getId()) {
            map = this.structureMap;
        } else if (itemTypeId == CoreArtifactTypes.InterfaceDataElementArray.getId() || itemTypeId == CoreArtifactTypes.InterfaceDataElement.getId()) {
            map = this.elementMap;
        } else if (itemTypeId == CoreArtifactTypes.InterfacePlatformType.getId()) {
            map = this.typeMap;
        } else if (itemTypeId == CoreArtifactTypes.InterfaceEnum.getId()) {
            map = this.enumMap;
        }
        if (map != null) {
            List<ChangeItem> changes = this.getListOrDefault(map, changeItem.getArtId().getId());
            changes.add(changeItem);
            map.put(changeItem.getArtId(), changes);
        }
    }
}

