/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementArrayApi;
import org.eclipse.osee.mim.InterfaceElementSearchEndpoint;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.types.ElementPosition;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;

public class InterfaceElementSearchEndpointImpl
implements InterfaceElementSearchEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final InterfaceElementApi elementApi;
    private final InterfaceElementArrayApi elementArrayApi;
    private final InterfacePlatformTypeApi platformApi;

    public InterfaceElementSearchEndpointImpl(BranchId branch, UserId account, InterfaceElementApi interfaceElementApi, InterfaceElementArrayApi interfaceElementArrayApi, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.account = account;
        this.branch = branch;
        this.elementApi = interfaceElementApi;
        this.elementArrayApi = interfaceElementArrayApi;
        this.platformApi = interfacePlatformTypeApi;
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElements() {
        return this.elementApi.getAll(this.branch);
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElements(String filter) {
        return this.elementApi.getFiltered(this.branch, filter);
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElementsOfType(ArtifactId platformTypeId) {
        return this.elementApi.getElementsByType(this.branch, platformTypeId);
    }

    @Override
    public ElementPosition findElement(ArtifactId elementId) {
        return new ElementPosition();
    }
}

