/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.types.PLGenericDBObject;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class InterfaceConnection
extends PLGenericDBObject {
    public static final InterfaceConnection SENTINEL = new InterfaceConnection();
    private String Name;
    private String Description;
    private String TransportType;
    private Long primaryNode;
    private Long secondaryNode;
    private ApplicabilityToken applicability;

    public InterfaceConnection(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceConnection(ArtifactReadable art) {
        super(art);
        this.setPrimaryNode(((ArtifactReadable)art.getRelated(CoreRelationTypes.InterfaceConnectionPrimary_Node).getOneOrDefault((Object)ArtifactReadable.SENTINEL)).getId());
        this.setSecondaryNode(((ArtifactReadable)art.getRelated(CoreRelationTypes.InterfaceConnectionSecondary_Node).getOneOrDefault((Object)ArtifactReadable.SENTINEL)).getId());
        this.setTransportType((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceTransportType, (Object)"ETHERNET"));
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public InterfaceConnection(Long id, String name) {
        super(id, name);
    }

    public InterfaceConnection() {
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public Long getSecondaryNode() {
        return this.secondaryNode;
    }

    public void setSecondaryNode(Long secondaryNode) {
        this.secondaryNode = secondaryNode;
    }

    public Long getPrimaryNode() {
        return this.primaryNode;
    }

    public void setPrimaryNode(Long primaryNode) {
        this.primaryNode = primaryNode;
    }

    public String getTransportType() {
        return this.TransportType;
    }

    public void setTransportType(String transportType) {
        this.TransportType = transportType;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }
}

