/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.server.application;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.server.application.internal.ServerHealthEndpointImpl;

@ApplicationPath(value="server")
public class ServerApplication
extends Application {
    private final Set<Object> singletons = new HashSet<Object>();
    private IApplicationServerManager applicationServerManager;
    private final Map<String, JdbcService> jdbcServices = new ConcurrentHashMap<String, JdbcService>();
    private IAuthenticationManager authManager;
    private ActivityLog activityLog;

    public void setActivityLog(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public void setAuthenticationManager(IAuthenticationManager authManager) {
        this.authManager = authManager;
    }

    public void setApplicationServerManager(IApplicationServerManager applicationServerManager) {
        this.applicationServerManager = applicationServerManager;
    }

    public void addJdbcService(JdbcService jdbcService) {
        this.jdbcServices.put(jdbcService.getId(), jdbcService);
    }

    public void removeJdbcService(JdbcService jdbcService) {
        this.jdbcServices.remove(jdbcService.getId());
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void start(Map<String, Object> properties) {
        this.singletons.add(new ServerHealthEndpointImpl(this.applicationServerManager, this.jdbcServices, this.authManager, this.activityLog));
    }

    public void stop() {
        this.singletons.clear();
    }
}

